/*
 * Decompiled with CFR 0.152.
 */
package datafu.org.apache.commons.math;

import datafu.org.apache.commons.math.ConvergingAlgorithm;
import datafu.org.apache.commons.math.MaxIterationsExceededException;

public abstract class ConvergingAlgorithmImpl
implements ConvergingAlgorithm {
    protected double absoluteAccuracy;
    protected double relativeAccuracy;
    protected int maximalIterationCount;
    protected double defaultAbsoluteAccuracy;
    protected double defaultRelativeAccuracy;
    protected int defaultMaximalIterationCount;
    protected int iterationCount;

    @Deprecated
    protected ConvergingAlgorithmImpl(int defaultMaximalIterationCount, double defaultAbsoluteAccuracy) {
        this.defaultAbsoluteAccuracy = defaultAbsoluteAccuracy;
        this.defaultRelativeAccuracy = 1.0E-14;
        this.absoluteAccuracy = defaultAbsoluteAccuracy;
        this.relativeAccuracy = this.defaultRelativeAccuracy;
        this.defaultMaximalIterationCount = defaultMaximalIterationCount;
        this.maximalIterationCount = defaultMaximalIterationCount;
        this.iterationCount = 0;
    }

    @Deprecated
    protected ConvergingAlgorithmImpl() {
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void setAbsoluteAccuracy(double accuracy) {
        this.absoluteAccuracy = accuracy;
    }

    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    public void resetAbsoluteAccuracy() {
        this.absoluteAccuracy = this.defaultAbsoluteAccuracy;
    }

    public void setMaximalIterationCount(int count) {
        this.maximalIterationCount = count;
    }

    public int getMaximalIterationCount() {
        return this.maximalIterationCount;
    }

    public void resetMaximalIterationCount() {
        this.maximalIterationCount = this.defaultMaximalIterationCount;
    }

    public void setRelativeAccuracy(double accuracy) {
        this.relativeAccuracy = accuracy;
    }

    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    public void resetRelativeAccuracy() {
        this.relativeAccuracy = this.defaultRelativeAccuracy;
    }

    protected void resetIterationsCounter() {
        this.iterationCount = 0;
    }

    protected void incrementIterationsCounter() throws MaxIterationsExceededException {
        if (++this.iterationCount > this.maximalIterationCount) {
            throw new MaxIterationsExceededException(this.maximalIterationCount);
        }
    }
}

