/*
 * Decompiled with CFR 0.152.
 */
package datafu.org.apache.commons.math.distribution;

import datafu.org.apache.commons.math.MathException;
import datafu.org.apache.commons.math.MathRuntimeException;
import datafu.org.apache.commons.math.distribution.AbstractIntegerDistribution;
import datafu.org.apache.commons.math.distribution.PascalDistribution;
import datafu.org.apache.commons.math.exception.util.LocalizedFormats;
import datafu.org.apache.commons.math.special.Beta;
import datafu.org.apache.commons.math.util.FastMath;
import datafu.org.apache.commons.math.util.MathUtils;
import java.io.Serializable;

public class PascalDistributionImpl
extends AbstractIntegerDistribution
implements PascalDistribution,
Serializable {
    private static final long serialVersionUID = 6751309484392813623L;
    private int numberOfSuccesses;
    private double probabilityOfSuccess;

    public PascalDistributionImpl(int r, double p) {
        this.setNumberOfSuccessesInternal(r);
        this.setProbabilityOfSuccessInternal(p);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Deprecated
    public void setNumberOfSuccesses(int successes) {
        this.setNumberOfSuccessesInternal(successes);
    }

    private void setNumberOfSuccessesInternal(int successes) {
        if (successes < 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NEGATIVE_NUMBER_OF_SUCCESSES, successes);
        }
        this.numberOfSuccesses = successes;
    }

    @Deprecated
    public void setProbabilityOfSuccess(double p) {
        this.setProbabilityOfSuccessInternal(p);
    }

    private void setProbabilityOfSuccessInternal(double p) {
        if (p < 0.0 || p > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_SIMPLE, p, 0.0, 1.0);
        }
        this.probabilityOfSuccess = p;
    }

    protected int getDomainLowerBound(double p) {
        return -1;
    }

    protected int getDomainUpperBound(double p) {
        return 0x7FFFFFFE;
    }

    public double cumulativeProbability(int x) throws MathException {
        double ret = x < 0 ? 0.0 : Beta.regularizedBeta(this.probabilityOfSuccess, this.numberOfSuccesses, x + 1);
        return ret;
    }

    public double probability(int x) {
        double ret = x < 0 ? 0.0 : MathUtils.binomialCoefficientDouble(x + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * FastMath.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * FastMath.pow(1.0 - this.probabilityOfSuccess, x);
        return ret;
    }

    public int inverseCumulativeProbability(double p) throws MathException {
        int ret = p == 0.0 ? -1 : (p == 1.0 ? Integer.MAX_VALUE : super.inverseCumulativeProbability(p));
        return ret;
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public double getNumericalMean() {
        double p = this.getProbabilityOfSuccess();
        double r = this.getNumberOfSuccesses();
        return r * p / (1.0 - p);
    }

    public double getNumericalVariance() {
        double p = this.getProbabilityOfSuccess();
        double r = this.getNumberOfSuccesses();
        double pInv = 1.0 - p;
        return r * p / (pInv * pInv);
    }
}

