/*
 * Decompiled with CFR 0.152.
 */
package datafu.org.apache.commons.math.exception;

import datafu.org.apache.commons.math.exception.MathThrowable;
import datafu.org.apache.commons.math.exception.util.ArgUtils;
import datafu.org.apache.commons.math.exception.util.Localizable;
import datafu.org.apache.commons.math.exception.util.LocalizedFormats;
import datafu.org.apache.commons.math.exception.util.MessageFactory;
import java.util.Locale;

public class MathUnsupportedOperationException
extends UnsupportedOperationException
implements MathThrowable {
    private static final long serialVersionUID = -6024911025449780478L;
    private final Localizable specific;
    private final Object[] arguments;

    public MathUnsupportedOperationException(Object ... args) {
        this(null, args);
    }

    public MathUnsupportedOperationException(Localizable specific, Object ... args) {
        this.specific = specific;
        this.arguments = ArgUtils.flatten(args);
    }

    public Localizable getSpecificPattern() {
        return this.specific;
    }

    public Localizable getGeneralPattern() {
        return LocalizedFormats.UNSUPPORTED_OPERATION;
    }

    public Object[] getArguments() {
        return (Object[])this.arguments.clone();
    }

    public String getMessage(Locale locale) {
        return MessageFactory.buildMessage(locale, this.specific, LocalizedFormats.UNSUPPORTED_OPERATION, this.arguments);
    }

    public String getMessage() {
        return this.getMessage(Locale.US);
    }

    public String getLocalizedMessage() {
        return this.getMessage(Locale.getDefault());
    }
}

