/*
 * Decompiled with CFR 0.152.
 */
package datafu.org.apache.commons.math.random;

import datafu.org.apache.commons.math.random.MersenneTwister;
import datafu.org.apache.commons.math.random.RandomGenerator;
import datafu.org.apache.commons.math.random.RandomVectorGenerator;
import datafu.org.apache.commons.math.util.FastMath;

public class UnitSphereRandomVectorGenerator
implements RandomVectorGenerator {
    private final RandomGenerator rand;
    private final int dimension;

    public UnitSphereRandomVectorGenerator(int dimension, RandomGenerator rand) {
        this.dimension = dimension;
        this.rand = rand;
    }

    public UnitSphereRandomVectorGenerator(int dimension) {
        this(dimension, new MersenneTwister());
    }

    public double[] nextVector() {
        double normSq;
        double[] v = new double[this.dimension];
        do {
            normSq = 0.0;
            for (int i = 0; i < this.dimension; ++i) {
                double comp;
                v[i] = comp = 2.0 * this.rand.nextDouble() - 1.0;
                normSq += comp * comp;
            }
        } while (normSq > 1.0);
        double f = 1.0 / FastMath.sqrt(normSq);
        int i = 0;
        while (i < this.dimension) {
            int n = i++;
            v[n] = v[n] * f;
        }
        return v;
    }
}

