/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class BagConcat
extends EvalFunc<DataBag> {
    public DataBag exec(Tuple input) throws IOException {
        DataBag output = BagFactory.getInstance().newDefaultBag();
        if (input.size() > 1) {
            for (int i = 0; i < input.size(); ++i) {
                Object o = input.get(i);
                if (!(o instanceof DataBag)) {
                    throw new RuntimeException("Expected a TUPLE of BAGs as input");
                }
                DataBag inputBag = (DataBag)o;
                for (Tuple elem : inputBag) {
                    output.add(elem);
                }
            }
        } else {
            DataBag outerBag = (DataBag)input.get(0);
            for (Tuple outerTuple : outerBag) {
                DataBag innerBag = (DataBag)outerTuple.get(0);
                for (Tuple innerTuple : innerBag) {
                    output.add(innerTuple);
                }
            }
        }
        return output;
    }

    public Schema outputSchema(Schema input) {
        try {
            Schema outputBagTupleSchema = null;
            if (input.size() == 0) {
                throw new RuntimeException("Expected input tuple to contain fields. Got none.");
            }
            if (input.size() != 1) {
                for (Schema.FieldSchema fieldSchema : input.getFields()) {
                    if (fieldSchema.type != 120) {
                        this.throwBadTypeError("Expected a TUPLE of BAGs as input.  Got instead: %s in schema: %s", fieldSchema.type, input);
                    }
                    if (fieldSchema.schema != null) continue;
                    this.throwBadSchemaError(fieldSchema.alias, input);
                }
                outputBagTupleSchema = input.getField((int)0).schema;
            } else {
                Schema.FieldSchema fieldSchema = input.getField(0);
                if (fieldSchema.type != 120) {
                    this.throwBadTypeError("Expected a BAG of BAGs as input.  Got instead: %s in schema: %s", fieldSchema.type, input);
                }
                Schema outerBagTuple = input.getField((int)0).schema;
                Schema outerBagSchema = outerBagTuple.getField((int)0).schema;
                if (outerBagSchema.size() != 1) {
                    throw new RuntimeException(String.format("Expected outer bag to have only a single field.  Got instead: %s", outerBagSchema.prettyPrint()));
                }
                Schema.FieldSchema outerBagFieldSchema = outerBagSchema.getField(0);
                if (outerBagFieldSchema.type != 120) {
                    this.throwBadTypeError("Expected a BAG of BAGs as input.  Got instead: %s", outerBagFieldSchema.type, outerBagTuple);
                }
                Schema.FieldSchema innerTupleSchema = outerBagSchema.getField(0);
                if (innerTupleSchema.schema == null) {
                    this.throwBadSchemaError(innerTupleSchema.alias, outerBagSchema);
                }
                outputBagTupleSchema = innerTupleSchema.schema;
            }
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), outputBagTupleSchema, 120));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void throwBadSchemaError(String alias, Schema schema) throws FrontendException {
        throw new FrontendException(String.format("Expected non-null schema for all bags. Got null on field %s, in: %s", alias, schema.prettyPrint()));
    }

    private void throwBadTypeError(String expectedMessage, byte actualType, Schema schema) throws FrontendException {
        throw new FrontendException(String.format(expectedMessage, DataType.findTypeName((byte)actualType), schema.prettyPrint()));
    }
}

