/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import datafu.pig.util.AliasableEvalFunc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class BagGroup
extends AliasableEvalFunc<DataBag> {
    private final String FIELD_NAMES_PROPERTY = "FIELD_NAMES";
    private List<String> fieldNames;
    TupleFactory tupleFactory = TupleFactory.getInstance();
    BagFactory bagFactory = BagFactory.getInstance();

    @Override
    public Schema getOutputSchema(Schema input) {
        try {
            if (input.size() != 2) {
                throw new RuntimeException(String.format("Expected input of format (BAG, PROJECTED_BAG...). Got %d field.", input.size()));
            }
            Schema.FieldSchema bagFieldSchema = input.getField(0);
            if (bagFieldSchema.type != 120) {
                throw new RuntimeException(String.format("Expected input of format (BAG, PROJECTED_BAG...). Got %s as first field.", DataType.findTypeName((byte)bagFieldSchema.type)));
            }
            Schema.FieldSchema projectedBagFieldSchema = input.getField(1);
            if (projectedBagFieldSchema.type != 120) {
                throw new RuntimeException(String.format("Expected input of format (BAG, PROJECTED_BAG...). Got %s as second field.", DataType.findTypeName((byte)projectedBagFieldSchema.type)));
            }
            String bagName = bagFieldSchema.alias;
            if (bagFieldSchema.schema.size() == 1) {
                Schema.FieldSchema bagTupleFieldSchema = bagFieldSchema.schema.getField(0);
                if (bagTupleFieldSchema.type == 110 && bagTupleFieldSchema.alias != null) {
                    bagName = this.getPrefixedAliasName(bagName, bagTupleFieldSchema.alias);
                }
            }
            if (projectedBagFieldSchema.schema.size() == 1) {
                Schema.FieldSchema projectedBagTupleFieldSchema = projectedBagFieldSchema.schema.getField(0);
                if (projectedBagTupleFieldSchema.type == 110 && projectedBagTupleFieldSchema.schema != null) {
                    projectedBagFieldSchema = projectedBagTupleFieldSchema;
                }
            }
            Schema groupTupleSchema = new Schema();
            this.fieldNames = new ArrayList<String>(projectedBagFieldSchema.schema.size());
            for (int i = 0; i < projectedBagFieldSchema.schema.size(); ++i) {
                Schema.FieldSchema fieldSchema = projectedBagFieldSchema.schema.getField(i);
                String fieldName = fieldSchema.alias;
                this.fieldNames.add(this.getPrefixedAliasName(bagName, fieldName));
                groupTupleSchema.add(new Schema.FieldSchema(fieldSchema.alias, fieldSchema.type));
            }
            this.getInstanceProperties().put("FIELD_NAMES", this.fieldNames);
            Schema outputTupleSchema = new Schema();
            if (projectedBagFieldSchema.schema.size() > 1) {
                outputTupleSchema.add(new Schema.FieldSchema("group", groupTupleSchema, 110));
            } else {
                outputTupleSchema.add(new Schema.FieldSchema("group", groupTupleSchema.getField((int)0).type));
            }
            outputTupleSchema.add(bagFieldSchema);
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), outputTupleSchema, 120));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }

    public DataBag exec(Tuple input) throws IOException {
        HashMap<Tuple, List<Tuple>> groups = new HashMap<Tuple, List<Tuple>>();
        this.fieldNames = (List)this.getInstanceProperties().get("FIELD_NAMES");
        DataBag inputBag = (DataBag)input.get(0);
        for (Tuple tuple : inputBag) {
            Tuple key = this.extractKey(tuple);
            this.addGroup(groups, key, tuple);
        }
        DataBag outputBag = this.bagFactory.newDefaultBag();
        for (Tuple key : groups.keySet()) {
            Tuple outputTuple = this.tupleFactory.newTuple();
            if (this.fieldNames.size() > 1) {
                outputTuple.append((Object)key);
            } else {
                outputTuple.append(key.get(0));
            }
            DataBag groupBag = this.bagFactory.newDefaultBag();
            for (Tuple groupedTuple : (List)groups.get(key)) {
                groupBag.add(groupedTuple);
            }
            outputTuple.append((Object)groupBag);
            outputBag.add(outputTuple);
        }
        return outputBag;
    }

    private Tuple extractKey(Tuple tuple) throws ExecException {
        Tuple key = this.tupleFactory.newTuple();
        for (String field : this.fieldNames) {
            key.append(this.getObject(tuple, field));
        }
        return key;
    }

    private void addGroup(Map<Tuple, List<Tuple>> groups, Tuple key, Tuple value) {
        if (!groups.containsKey(key)) {
            groups.put(key, new LinkedList());
        }
        groups.get(key).add(value);
    }
}

