/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import datafu.pig.util.AliasableEvalFunc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class BagJoin
extends AliasableEvalFunc<DataBag> {
    private static final String BAG_NAMES_PROPERTY = "BagFullOuterJoin_BAG_NAMES";
    private static final String BAG_NAME_TO_JOIN_PREFIX_PROPERTY = "BagFullOuterJoin_BAG_NAME_TO_JOIN_PREFIX";
    private static final String BAG_NAME_TO_SIZE_PROPERTY = "BagFullOuterJoin_BAG_NAME_TO_SIZE_PROPERTY";
    private final JoinType joinType;
    ArrayList<String> bagNames;
    Map<String, String> bagNameToJoinKeyPrefix;
    Map<String, Integer> bagNameToSize;

    public BagJoin() {
        this("inner");
    }

    public BagJoin(String joinType) {
        if ("left".equals(joinType.toLowerCase())) {
            this.joinType = JoinType.LEFT;
        } else if ("full".equals(joinType.toLowerCase())) {
            this.joinType = JoinType.FULL;
        } else if ("inner".equals(joinType.toLowerCase())) {
            this.joinType = JoinType.INNER;
        } else {
            throw new IllegalArgumentException("Invalid constructor argument.  Valid values are 'left' or 'full', found: " + joinType);
        }
    }

    private void retrieveContextValues() {
        Properties properties = this.getInstanceProperties();
        this.bagNames = (ArrayList)properties.get(BAG_NAMES_PROPERTY);
        this.bagNameToJoinKeyPrefix = (Map)properties.get(BAG_NAME_TO_JOIN_PREFIX_PROPERTY);
        this.bagNameToSize = (Map)properties.get(BAG_NAME_TO_SIZE_PROPERTY);
    }

    public DataBag exec(Tuple input) throws IOException {
        this.retrieveContextValues();
        HashMap<String, String> joinKeyNames = new HashMap<String, String>();
        for (int i = 1; i < input.size(); i += 2) {
            joinKeyNames.put(this.bagNames.get(i / 2), (String)input.get(i));
        }
        JoinCollector collector = new JoinCollector(this.joinType);
        for (String bagName : this.bagNames) {
            DataBag bag = this.getBag(input, bagName);
            String joinKeyName = this.getPrefixedAliasName(this.bagNameToJoinKeyPrefix.get(bagName), (String)joinKeyNames.get(bagName));
            int tupleSize = this.bagNameToSize.get(bagName);
            if (bag == null) {
                throw new IOException("Error in instance: " + this.getInstanceName() + " with properties: " + this.getInstanceProperties() + " and tuple: " + input.toDelimitedString(", ") + " -- Expected bag, got null");
            }
            collector.join((Iterable<Tuple>)bag, joinKeyName, tupleSize);
        }
        DataBag outputBag = BagFactory.getInstance().newDefaultBag();
        for (List<Tuple> tuples : collector.getJoinData().values()) {
            for (Tuple tuple : tuples) {
                outputBag.add(tuple);
            }
        }
        return outputBag;
    }

    @Override
    public Schema getOutputSchema(Schema input) {
        ArrayList<String> bagNames = new ArrayList<String>(input.size() / 2);
        HashMap<String, String> bagNameToJoinPrefix = new HashMap<String, String>(input.size() / 2);
        HashMap<String, Integer> bagNameToSize = new HashMap<String, Integer>(input.size() / 2);
        Schema outputSchema = null;
        Schema bagSchema = new Schema();
        try {
            int i = 0;
            String bagName = null;
            String tupleName = null;
            for (Schema.FieldSchema outerField : input.getFields()) {
                if (i++ % 2 == 1) continue;
                bagName = outerField.alias;
                bagNames.add(bagName);
                if (bagName == null) {
                    bagName = "null";
                }
                if (outerField.schema == null) {
                    throw new RuntimeException("Expected input format of (bag, 'field') pairs. Did not receive a bag at index: " + i + ", alias: " + bagName + ". Instead received type: " + DataType.findTypeName((byte)outerField.type) + " in schema:" + input.toString());
                }
                Schema.FieldSchema tupleField = outerField.schema.getField(0);
                tupleName = tupleField.alias;
                bagNameToJoinPrefix.put(bagName, this.getPrefixedAliasName(outerField.alias, tupleName));
                if (tupleField.schema == null) {
                    this.log.error((Object)String.format("could not get schema for inner tuple %s in bag %s", tupleName, bagName));
                    continue;
                }
                bagNameToSize.put(bagName, tupleField.schema.size());
                for (Schema.FieldSchema innerField : tupleField.schema.getFields()) {
                    String innerFieldName = innerField.alias;
                    if (innerFieldName == null) {
                        innerFieldName = "null";
                    }
                    String outputFieldName = bagName + "::" + innerFieldName;
                    if (innerField.schema != null) {
                        bagSchema.add(new Schema.FieldSchema(outputFieldName, innerField.schema, innerField.type));
                        continue;
                    }
                    bagSchema.add(new Schema.FieldSchema(outputFieldName, innerField.type));
                }
            }
            outputSchema = new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), bagSchema, 120));
            this.log.debug((Object)("output schema: " + outputSchema.toString()));
        }
        catch (FrontendException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        Properties properties = this.getInstanceProperties();
        properties.put(BAG_NAMES_PROPERTY, bagNames);
        properties.put(BAG_NAME_TO_JOIN_PREFIX_PROPERTY, bagNameToJoinPrefix);
        properties.put(BAG_NAME_TO_SIZE_PROPERTY, bagNameToSize);
        return outputSchema;
    }

    class JoinCollector {
        private final JoinType joinType;
        Set<Object> keys;
        HashMap<Object, List<Tuple>> data;
        int tupleSize = 0;

        public JoinCollector(JoinType joinType) {
            this.joinType = joinType;
        }

        public void printData() throws ExecException {
            for (Map.Entry<Object, List<Tuple>> entry : this.data.entrySet()) {
                System.out.println(entry.getKey());
                for (Tuple t : entry.getValue()) {
                    System.out.println("\t" + t.toDelimitedString(", "));
                }
            }
        }

        public HashMap<Object, List<Tuple>> join(Iterable<Tuple> tuples, String keyName, int tupleSize) throws ExecException {
            if (this.data == null) {
                this.data = new HashMap();
                this.keys = new HashSet<Object>();
                for (Tuple tuple : tuples) {
                    Object key = BagJoin.this.getObject(tuple, keyName);
                    if (!this.data.containsKey(key)) {
                        this.data.put(key, new ArrayList());
                        this.keys.add(key);
                    }
                    this.data.get(key).add(tuple);
                }
                this.tupleSize = tupleSize;
                return this.data;
            }
            HashMap joinedData = new HashMap(this.data.size());
            HashSet<Object> joinedKeys = new HashSet<Object>();
            for (Tuple tuple : tuples) {
                Tuple t2;
                Object key = BagJoin.this.getObject(tuple, keyName);
                if (this.data.containsKey(key)) {
                    if (!joinedData.containsKey(key)) {
                        joinedData.put(key, new ArrayList());
                        joinedKeys.add(key);
                    }
                    for (Tuple t2 : this.data.get(key)) {
                        Tuple joinedTuple = TupleFactory.getInstance().newTuple();
                        for (Object o : t2.getAll()) {
                            joinedTuple.append(o);
                        }
                        for (Object o : tuple.getAll()) {
                            joinedTuple.append(o);
                        }
                        ((List)joinedData.get(key)).add(joinedTuple);
                    }
                    this.keys.remove(key);
                    continue;
                }
                if (this.joinType != JoinType.FULL) continue;
                if (!joinedData.containsKey(key)) {
                    joinedData.put(key, new ArrayList());
                    joinedKeys.add(key);
                }
                Tuple nullTuple = TupleFactory.getInstance().newTuple(this.tupleSize);
                t2 = tuple.getAll().iterator();
                while (t2.hasNext()) {
                    Object o = t2.next();
                    nullTuple.append(o);
                }
                ((List)joinedData.get(key)).add(nullTuple);
            }
            if (this.joinType == JoinType.LEFT || this.joinType == JoinType.FULL) {
                for (Object key : this.keys) {
                    if (!joinedData.containsKey(key)) {
                        joinedData.put(key, new ArrayList());
                        joinedKeys.add(key);
                    }
                    for (Tuple t : this.data.get(key)) {
                        Tuple joinedTuple = TupleFactory.getInstance().newTuple();
                        for (Object o : t.getAll()) {
                            joinedTuple.append(o);
                        }
                        for (int i = 0; i < tupleSize; ++i) {
                            joinedTuple.append(null);
                        }
                        ((List)joinedData.get(key)).add(joinedTuple);
                    }
                }
            }
            this.data = joinedData;
            this.keys = joinedKeys;
            this.tupleSize += tupleSize;
            return this.data;
        }

        public HashMap<Object, List<Tuple>> getJoinData() {
            return this.data;
        }
    }

    public static enum JoinType {
        INNER,
        LEFT,
        FULL;

    }
}

