/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class BagSplit
extends EvalFunc<DataBag> {
    private static final BagFactory bagFactory = BagFactory.getInstance();
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    private final boolean appendBagNum;

    public BagSplit() {
        this.appendBagNum = false;
    }

    public BagSplit(String appendBagNum) {
        this.appendBagNum = Boolean.parseBoolean(appendBagNum);
    }

    public DataBag exec(Tuple arg0) throws IOException {
        DataBag outputBag = bagFactory.newDefaultBag();
        Integer maxSize = (Integer)arg0.get(0);
        Object o = arg0.get(1);
        if (!(o instanceof DataBag)) {
            throw new RuntimeException("parameter must be a databag");
        }
        DataBag inputBag = (DataBag)o;
        DataBag currentBag = null;
        int count = 0;
        int numBags = 0;
        for (Tuple tuple : inputBag) {
            if (currentBag == null) {
                currentBag = bagFactory.newDefaultBag();
            }
            currentBag.add(tuple);
            if (++count < maxSize) continue;
            Tuple newTuple = tupleFactory.newTuple();
            newTuple.append((Object)currentBag);
            if (this.appendBagNum) {
                newTuple.append((Object)numBags);
            }
            ++numBags;
            outputBag.add(newTuple);
            count = 0;
            currentBag = null;
        }
        if (currentBag != null) {
            Tuple newTuple = tupleFactory.newTuple();
            newTuple.append(currentBag);
            if (this.appendBagNum) {
                newTuple.append((Object)numBags);
            }
            outputBag.add(newTuple);
        }
        return outputBag;
    }

    public Schema outputSchema(Schema input) {
        try {
            if (input.getField((int)0).type != 10) {
                throw new RuntimeException("Expected first argument to be an INTEGER");
            }
            if (input.getField((int)1).type != 120) {
                throw new RuntimeException("Expected second argument to be a BAG");
            }
            Schema tupleSchema = new Schema();
            tupleSchema.add(new Schema.FieldSchema("data", input.getField((int)1).schema.clone(), 120));
            if (this.appendBagNum) {
                tupleSchema.add(new Schema.FieldSchema("index", 10));
            }
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 120));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

