/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class CountEach
extends AccumulatorEvalFunc<DataBag> {
    private boolean flatten = false;
    private Map<Tuple, Integer> counts = new HashMap<Tuple, Integer>();

    public CountEach() {
    }

    public CountEach(String arg) {
        if (arg != null && arg.toLowerCase().equals("flatten")) {
            this.flatten = true;
        }
    }

    public void accumulate(Tuple input) throws IOException {
        DataBag inputBag = (DataBag)input.get(0);
        if (inputBag == null) {
            throw new IllegalArgumentException("Expected a bag, got null");
        }
        for (Tuple tuple : inputBag) {
            if (!this.counts.containsKey(tuple)) {
                this.counts.put(tuple, 0);
            }
            this.counts.put(tuple, this.counts.get(tuple) + 1);
        }
    }

    public DataBag getValue() {
        DataBag output = BagFactory.getInstance().newDefaultBag();
        for (Tuple tuple : this.counts.keySet()) {
            Tuple outputTuple = null;
            Tuple innerTuple = TupleFactory.getInstance().newTuple(tuple.getAll());
            if (this.flatten) {
                innerTuple.append((Object)this.counts.get(tuple));
                outputTuple = innerTuple;
            } else {
                outputTuple = TupleFactory.getInstance().newTuple();
                outputTuple.append((Object)innerTuple);
                outputTuple.append((Object)this.counts.get(tuple));
            }
            output.add(outputTuple);
        }
        return output;
    }

    public void cleanup() {
        this.counts.clear();
    }

    public Schema outputSchema(Schema input) {
        try {
            if (input.size() != 1) {
                throw new RuntimeException("Expected input to have one field");
            }
            Schema.FieldSchema bagFieldSchema = input.getField(0);
            if (bagFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            Schema inputBagSchema = bagFieldSchema.schema;
            if (inputBagSchema.getField((int)0).type != 110) {
                throw new RuntimeException(String.format("Expected input bag to contain a TUPLE, but instead found %s", DataType.findTypeName((byte)inputBagSchema.getField((int)0).type)));
            }
            Schema inputTupleSchema = inputBagSchema.getField((int)0).schema;
            if (inputTupleSchema == null) {
                inputTupleSchema = new Schema();
            }
            Schema outputTupleSchema = null;
            if (this.flatten) {
                outputTupleSchema = inputTupleSchema.clone();
                outputTupleSchema.add(new Schema.FieldSchema("count", 10));
            } else {
                outputTupleSchema = new Schema();
                outputTupleSchema.add(new Schema.FieldSchema("tuple_schema", inputTupleSchema.clone(), 110));
                outputTupleSchema.add(new Schema.FieldSchema("count", 10));
            }
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), outputTupleSchema, 120));
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

