/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import java.io.IOException;
import java.util.HashSet;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class DistinctBy
extends AccumulatorEvalFunc<DataBag> {
    private HashSet<Integer> fields = new HashSet();
    private HashSet<Tuple> seen = new HashSet();
    private DataBag outputBag;

    public DistinctBy(String ... fields) {
        for (String field : fields) {
            this.fields.add(Integer.parseInt(field));
        }
        this.cleanup();
    }

    public void accumulate(Tuple input) throws IOException {
        if (input.size() != 1) {
            throw new RuntimeException("Expected input to have only a single field");
        }
        if (input.getType(0) != 120) {
            throw new RuntimeException("Expected a BAG as input");
        }
        DataBag inputBag = (DataBag)input.get(0);
        for (Tuple t : inputBag) {
            Tuple distinctFieldTuple = this.getDistinctFieldTuple(t, this.fields);
            if (this.seen.contains(distinctFieldTuple)) continue;
            this.outputBag.add(t);
            this.seen.add(distinctFieldTuple);
        }
    }

    public void cleanup() {
        this.seen.clear();
        this.outputBag = BagFactory.getInstance().newDefaultBag();
    }

    public DataBag getValue() {
        return this.outputBag;
    }

    public Schema outputSchema(Schema input) {
        try {
            if (input.size() != 1) {
                throw new RuntimeException("Expected input to have only a single field");
            }
            Schema.FieldSchema inputFieldSchema = input.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            Schema inputBagSchema = inputFieldSchema.schema;
            if (inputBagSchema.getField((int)0).type != 110) {
                throw new RuntimeException(String.format("Expected input bag to contain a TUPLE, but instead found %s", DataType.findTypeName((byte)inputBagSchema.getField((int)0).type)));
            }
            Schema inputTupleSchema = inputBagSchema.getField((int)0).schema;
            Schema outputTupleSchema = inputTupleSchema.clone();
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), outputTupleSchema, 120));
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }

    private Tuple getDistinctFieldTuple(Tuple t, HashSet<Integer> distinctFieldPositions) throws ExecException {
        Tuple fieldTuple = TupleFactory.getInstance().newTuple(distinctFieldPositions.size());
        int idx = 0;
        for (int i = 0; i < t.size(); ++i) {
            if (!distinctFieldPositions.contains(i)) continue;
            fieldTuple.set(idx, t.get(i));
            ++idx;
        }
        return fieldTuple;
    }
}

