/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import datafu.pig.util.ContextualEvalFunc;
import java.io.IOException;
import java.util.Arrays;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class EmptyBagToNullFields
extends ContextualEvalFunc<DataBag> {
    public DataBag exec(Tuple tuple) throws IOException {
        if (tuple.size() == 0 || tuple.get(0) == null) {
            return null;
        }
        Object o = tuple.get(0);
        if (o instanceof DataBag) {
            DataBag bag = (DataBag)o;
            if (bag.size() == 0L) {
                int tupleSize = (Integer)this.getInstanceProperties().get("tuplesize");
                return BagFactory.getInstance().newDefaultBag(Arrays.asList(TupleFactory.getInstance().newTuple(tupleSize)));
            }
            return bag;
        }
        throw new IllegalArgumentException("expected a null or a bag");
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            if (input.size() != 1) {
                throw new RuntimeException("Expected only a single field as input");
            }
            if (input.getField((int)0).type != 120) {
                throw new RuntimeException("Expected a BAG as input, but found " + DataType.findTypeName((byte)input.getField((int)0).type));
            }
            int innerTupleSize = input.getField((int)0).schema.getField((int)0).schema.getFields().size();
            this.getInstanceProperties().put("tuplesize", (Object)innerTupleSize);
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
        return input;
    }
}

