/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import java.io.IOException;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class Enumerate
extends AccumulatorEvalFunc<DataBag> {
    private final int start;
    private DataBag outputBag;
    private long i;
    private long count;

    public Enumerate() {
        this("0");
    }

    public Enumerate(String start) {
        this.start = Integer.parseInt(start);
        this.cleanup();
    }

    public void accumulate(Tuple arg0) throws IOException {
        DataBag inputBag = (DataBag)arg0.get(0);
        for (Tuple t : inputBag) {
            Tuple t1 = TupleFactory.getInstance().newTuple(t.getAll());
            t1.append((Object)this.i);
            this.outputBag.add(t1);
            if (this.count % 1000000L == 0L) {
                this.outputBag.spill();
                this.count = 0L;
            }
            ++this.i;
            ++this.count;
        }
    }

    public void cleanup() {
        this.outputBag = BagFactory.getInstance().newDefaultBag();
        this.i = this.start;
        this.count = 0L;
    }

    public DataBag getValue() {
        return this.outputBag;
    }

    public Schema outputSchema(Schema input) {
        try {
            if (input.size() != 1) {
                throw new RuntimeException("Expected input to have only a single field");
            }
            Schema.FieldSchema inputFieldSchema = input.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            Schema inputBagSchema = inputFieldSchema.schema;
            if (inputBagSchema.getField((int)0).type != 110) {
                throw new RuntimeException(String.format("Expected input bag to contain a TUPLE, but instead found %s", DataType.findTypeName((byte)inputBagSchema.getField((int)0).type)));
            }
            Schema inputTupleSchema = inputBagSchema.getField((int)0).schema;
            Schema outputTupleSchema = inputTupleSchema.clone();
            outputTupleSchema.add(new Schema.FieldSchema("i", 15));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), outputTupleSchema, 120));
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

