/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import datafu.pig.util.SimpleEvalFunc;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.Accumulator;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class FirstTupleFromBag
extends SimpleEvalFunc<Tuple>
implements Accumulator<Tuple> {
    private Tuple result = null;
    private boolean found = false;

    public void accumulate(Tuple tuple) throws IOException {
        if (!this.found) {
            DataBag bag = (DataBag)tuple.get(0);
            Tuple defaultValue = (Tuple)tuple.get(1);
            this.result = this.call(bag, defaultValue);
            this.found = true;
        }
    }

    public void cleanup() {
        this.found = false;
        this.result = null;
    }

    public Tuple getValue() {
        return this.result;
    }

    public Tuple call(DataBag bag, Tuple defaultValue) throws IOException {
        Iterator iterator = bag.iterator();
        if (iterator.hasNext()) {
            Tuple t = (Tuple)iterator.next();
            return t;
        }
        return defaultValue;
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            return new Schema(input.getField((int)0).schema);
        }
        catch (Exception e) {
            return null;
        }
    }
}

