/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import datafu.pig.util.SimpleEvalFunc;
import java.io.IOException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class ReverseEnumerate
extends SimpleEvalFunc<DataBag> {
    private final int start;

    public ReverseEnumerate() {
        this.start = 0;
    }

    public ReverseEnumerate(String start) {
        this.start = Integer.parseInt(start);
    }

    public DataBag call(DataBag inputBag) throws IOException {
        DataBag outputBag = BagFactory.getInstance().newDefaultBag();
        long i = this.start;
        long count = 0L;
        i = inputBag.size() - 1L + (long)this.start;
        for (Tuple t : inputBag) {
            Tuple t1 = TupleFactory.getInstance().newTuple(t.getAll());
            t1.append((Object)i);
            outputBag.add(t1);
            if (count % 1000000L == 0L) {
                outputBag.spill();
                count = 0L;
            }
            --i;
            ++count;
        }
        return outputBag;
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            if (input.size() != 1) {
                throw new RuntimeException("Expected input to have only a single field");
            }
            Schema.FieldSchema inputFieldSchema = input.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            Schema inputBagSchema = inputFieldSchema.schema;
            if (inputBagSchema.getField((int)0).type != 110) {
                throw new RuntimeException(String.format("Expected input bag to contain a TUPLE, but instead found %s", DataType.findTypeName((byte)inputBagSchema.getField((int)0).type)));
            }
            Schema inputTupleSchema = inputBagSchema.getField((int)0).schema;
            Schema outputTupleSchema = inputTupleSchema.clone();
            outputTupleSchema.add(new Schema.FieldSchema("i", 15));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), outputTupleSchema, 120));
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

