/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import java.io.IOException;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class TupleFromBag
extends AccumulatorEvalFunc<Tuple> {
    private int tupleIndex = 0;
    private Tuple result = null;
    private Tuple defaultResult = null;

    public void accumulate(Tuple tinput) throws IOException {
        if (this.result == null) {
            try {
                DataBag samples = (DataBag)tinput.get(0);
                int index = ((Number)tinput.get(1)).intValue();
                for (Tuple tuple : samples) {
                    if (this.tupleIndex == index) {
                        this.result = tuple;
                        return;
                    }
                    ++this.tupleIndex;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.defaultResult == null && tinput.size() == 3) {
                this.defaultResult = DataType.toTuple((Object)tinput.get(2));
            }
        }
    }

    public Schema outputSchema(Schema input) {
        try {
            if (input.size() != 2 && input.size() != 3) {
                throw new RuntimeException("Expected input to have two or three fields");
            }
            if (input.getField((int)1).type != 10) {
                throw new RuntimeException("Expected an INT as second input, got: " + input.getField((int)1).type);
            }
            return new Schema(input.getField((int)0).schema);
        }
        catch (FrontendException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void cleanup() {
        this.tupleIndex = 0;
        this.result = null;
        this.defaultResult = null;
    }

    public Tuple getValue() {
        return this.result != null ? this.result : this.defaultResult;
    }
}

