/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import java.io.IOException;
import java.util.Arrays;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public class UnorderedPairs
extends EvalFunc<DataBag> {
    private static final BagFactory bagFactory = BagFactory.getInstance();
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();

    public DataBag exec(Tuple input) throws IOException {
        PigStatusReporter reporter = PigStatusReporter.getInstance();
        try {
            DataBag inputBag = (DataBag)input.get(0);
            DataBag outputBag = bagFactory.newDefaultBag();
            long i = 0L;
            long cnt = 0L;
            if (inputBag != null) {
                for (Tuple elem1 : inputBag) {
                    long j = 0L;
                    for (Tuple elem2 : inputBag) {
                        if (j > i) {
                            outputBag.add(tupleFactory.newTuple(Arrays.asList(elem1, elem2)));
                            ++cnt;
                        }
                        ++j;
                        if (reporter != null) {
                            reporter.progress();
                        }
                        if (cnt % 1000000L != 0L) continue;
                        outputBag.spill();
                        cnt = 0L;
                    }
                    ++i;
                }
            }
            return outputBag;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception processing input of " + ((Object)((Object)this)).getClass().getName(), e);
        }
    }

    public Schema outputSchema(Schema input) {
        try {
            if (input.size() != 1) {
                throw new RuntimeException("Expected input to have only a single field");
            }
            Schema.FieldSchema inputFieldSchema = input.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            Schema inputBagSchema = inputFieldSchema.schema;
            if (inputBagSchema.getField((int)0).type != 110) {
                throw new RuntimeException(String.format("Expected input bag to contain a TUPLE, but instead found %s", DataType.findTypeName((byte)inputBagSchema.getField((int)0).type)));
            }
            Schema ouputTupleSchema = new Schema();
            ouputTupleSchema.add(new Schema.FieldSchema("elem1", inputBagSchema.getField((int)0).schema.clone(), 110));
            ouputTupleSchema.add(new Schema.FieldSchema("elem2", inputBagSchema.getField((int)0).schema.clone(), 110));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), ouputTupleSchema, 120));
        }
        catch (Exception e) {
            return null;
        }
    }
}

