/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.bags;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultDataBag;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class ZipBags
extends EvalFunc<DataBag> {
    public DataBag exec(Tuple input) throws IOException {
        DefaultDataBag outputBag = new DefaultDataBag();
        ArrayList<Iterator> bagIterators = new ArrayList<Iterator>();
        for (int i = 0; i < input.size(); ++i) {
            Object obj = input.get(i);
            if (!(obj instanceof DataBag)) {
                throw new IllegalArgumentException("Expected all fields to be bags");
            }
            DataBag bag = (DataBag)obj;
            bagIterators.add(bag.iterator());
        }
        while (((Iterator)bagIterators.get(0)).hasNext()) {
            DefaultTuple nextTuple = new DefaultTuple();
            for (Iterator iter : bagIterators) {
                if (!iter.hasNext()) {
                    throw new IllegalArgumentException("The first bag must be the shortest one");
                }
                Tuple tempTuple = (Tuple)iter.next();
                for (int i = 0; i < tempTuple.size(); ++i) {
                    nextTuple.append(tempTuple.get(i));
                }
            }
            outputBag.add((Tuple)nextTuple);
        }
        return outputBag;
    }

    public Schema outputSchema(Schema input) {
        Schema bagTupleSchema = new Schema();
        HashSet<String> aliasSet = new HashSet<String>();
        for (Schema.FieldSchema schema : input.getFields()) {
            if (schema.schema == null) {
                throw new RuntimeException("Inner bag schemas are null");
            }
            for (Schema.FieldSchema innerBagTuple : schema.schema.getFields()) {
                for (Schema.FieldSchema tupleField : innerBagTuple.schema.getFields()) {
                    if (!aliasSet.add(tupleField.alias)) {
                        throw new RuntimeException("Duplicate field alias specified");
                    }
                    bagTupleSchema.add(tupleField);
                }
            }
        }
        try {
            return new Schema(new Schema.FieldSchema("zipped", bagTupleSchema, 120));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

