/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.geo;

import datafu.pig.util.SimpleEvalFunc;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class HaversineDistInMiles
extends SimpleEvalFunc<Double> {
    public static final double EARTH_RADIUS = 3958.75;

    public Double call(Double lat1, Double lng1, Double lat2, Double lng2) {
        if (lat1 == null || lng1 == null || lat2 == null || lng2 == null) {
            return null;
        }
        double d_lat = Math.toRadians(lat2 - lat1);
        double d_long = Math.toRadians(lng2 - lng1);
        double a = Math.sin(d_lat / 2.0) * Math.sin(d_lat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(d_long / 2.0) * Math.sin(d_long / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 3958.75 * c;
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema("dist", 25));
    }
}

