/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import datafu.pig.util.SimpleEvalFunc;
import java.math.BigInteger;

public class Hasher
extends SimpleEvalFunc<String> {
    protected HashFunction hash_func = null;
    private static final String HASH_NAMES = "'murmur3-32' (with optional seed); 'murmur3-128' (with optional seed); 'sip24' (with optional seed); 'crc32', 'adler32', 'md5'; 'sha1'; 'sha256'; 'sha512';  or 'good-{number of bits}'.";
    protected static final String SEEDED_HASH_NAMES = "'murmur3-32' (with optional seed); 'murmur3-128' (with optional seed); 'sip24' (with optional seed)";

    public Hasher() throws IllegalArgumentException, RuntimeException {
        this("murmur3-32");
    }

    public Hasher(String algorithm) throws IllegalArgumentException, RuntimeException {
        this.makeHashFunc(algorithm);
    }

    public Hasher(String algorithm, String seed) throws IllegalArgumentException, RuntimeException {
        this.makeHashFunc(algorithm, seed);
    }

    private void makeHashFunc(String algorithm) throws IllegalArgumentException, RuntimeException {
        if (this.hash_func != null) {
            throw new RuntimeException("The hash function should only be set once per instance");
        }
        if (algorithm.startsWith("good-")) {
            int bits = Integer.parseInt(algorithm.substring(5));
            this.hash_func = Hashing.goodFastHash((int)bits);
        } else if (algorithm.equals("murmur3-32")) {
            this.hash_func = Hashing.murmur3_32();
        } else if (algorithm.equals("murmur3-128")) {
            this.hash_func = Hashing.murmur3_128();
        } else if (algorithm.equals("sip24")) {
            this.hash_func = Hashing.sipHash24();
        } else if (algorithm.equals("sha1")) {
            this.hash_func = Hashing.sha1();
        } else if (algorithm.equals("sha256")) {
            this.hash_func = Hashing.sha256();
        } else if (algorithm.equals("sha512")) {
            this.hash_func = Hashing.sha512();
        } else if (algorithm.equals("md5")) {
            this.hash_func = Hashing.md5();
        } else if (algorithm.equals("adler32")) {
            this.hash_func = Hashing.adler32();
        } else if (algorithm.equals("crc32")) {
            this.hash_func = Hashing.crc32();
        } else {
            throw new IllegalArgumentException("No hash function found for algorithm " + algorithm + ". Allowed values include " + HASH_NAMES);
        }
    }

    protected void makeHashFunc(String algorithm, String seed) throws IllegalArgumentException, RuntimeException {
        block8: {
            try {
                if (algorithm.equals("murmur3-32")) {
                    if (seed.length() != 8) {
                        throw new IllegalArgumentException("Seed for " + algorithm + " must be an 8-character string representing a 32-bit unsigned number in hexadecimal.");
                    }
                    int seedint = Hasher.intFromHex(seed);
                    this.hash_func = Hashing.murmur3_32((int)seedint);
                    break block8;
                }
                if (algorithm.equals("murmur3-128")) {
                    if (seed.length() != 8) {
                        throw new IllegalArgumentException("Seed for " + algorithm + " must be an 8-character string representing a 32-bit unsigned number in hexadecimal.");
                    }
                    int seedint = Hasher.intFromHex(seed);
                    this.hash_func = Hashing.murmur3_128((int)seedint);
                    break block8;
                }
                if (algorithm.equals("sip24")) {
                    if (seed.length() != 32) {
                        throw new IllegalArgumentException("Seed for " + algorithm + " must be a 32-character string representing a 128-bit unsigned number in hexadecimal.");
                    }
                    long k0 = Hasher.longFromHex(seed.substring(0, 16));
                    long k1 = Hasher.longFromHex(seed.substring(16, 32));
                    this.hash_func = Hashing.sipHash24((long)k0, (long)k1);
                    break block8;
                }
                throw new IllegalArgumentException("No hash function found for algorithm " + algorithm + " with a seed. Allowed values include " + SEEDED_HASH_NAMES);
            }
            catch (NumberFormatException err) {
                throw new RuntimeException(err);
            }
        }
    }

    public static long longFromHex(String hex_str) {
        return new BigInteger(hex_str, 16).longValue();
    }

    public static int intFromHex(String hex_str) {
        return new BigInteger(hex_str, 16).intValue();
    }

    public String call(String val) {
        return this.hash_func.hashBytes(val.getBytes()).toString();
    }
}

