/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash;

import com.google.common.hash.HashFunction;
import datafu.pig.hash.Hasher;
import java.util.Random;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class HasherRand
extends Hasher {
    protected HashFunction hash_func;
    protected final String algorithm;

    public HasherRand() {
        this("murmur3-32");
    }

    public HasherRand(String alg) {
        this.algorithm = alg;
    }

    @Override
    public String call(String val) {
        if (this.hash_func == null) {
            String rand_seed = (String)this.getInstanceProperties().get("rand_seed");
            super.makeHashFunc(this.algorithm, rand_seed);
        }
        return super.call(val);
    }

    @Override
    protected void onReady(Schema in_schema, Schema out_schema) {
        String rand_seed;
        Random rg = this.getRandomGenerator();
        if (this.algorithm.equals("murmur3-32")) {
            int rand_int = rg.nextInt();
            rand_seed = String.format("%08x", rand_int);
        } else if (this.algorithm.equals("murmur3-128")) {
            int rand_int = rg.nextInt();
            rand_seed = String.format("%08x", rand_int);
        } else if (this.algorithm.equals("sip24")) {
            long rand_k0 = rg.nextLong();
            long rand_k1 = rg.nextLong();
            rand_seed = String.format("%016x%016x", rand_k0, rand_k1);
        } else {
            throw new IllegalArgumentException("No hash function found for algorithm " + this.algorithm + " with a seed. Allowed values include " + "'murmur3-32' (with optional seed); 'murmur3-128' (with optional seed); 'sip24' (with optional seed)");
        }
        this.getInstanceProperties().put("rand_seed", rand_seed);
        super.onReady(in_schema, out_schema);
    }

    protected Random getRandomGenerator() {
        return new Random();
    }
}

