/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash;

import datafu.pig.util.SimpleEvalFunc;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA
extends SimpleEvalFunc<String> {
    private final MessageDigest sha;
    private final String hex_format;

    public SHA() {
        this("256");
    }

    public SHA(String algorithm) {
        try {
            this.sha = MessageDigest.getInstance("SHA-" + algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (algorithm.equals("1")) {
            this.hex_format = "%040x";
        } else if (algorithm.equals("256")) {
            this.hex_format = "%064x";
        } else if (algorithm.equals("384")) {
            this.hex_format = "%096x";
        } else if (algorithm.equals("512")) {
            this.hex_format = "%0128x";
        } else {
            throw new RuntimeException("Don't know how to format output for SHA-" + algorithm);
        }
    }

    public String call(String value) {
        return String.format(this.hex_format, new BigInteger(1, this.sha.digest(value.getBytes())));
    }
}

