/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash.lsh;

import datafu.pig.hash.lsh.LSHFunc;
import datafu.pig.hash.lsh.cosine.HyperplaneLSH;
import datafu.pig.hash.lsh.interfaces.LSH;
import datafu.pig.hash.lsh.interfaces.LSHCreator;
import org.apache.commons.math.MathException;
import org.apache.commons.math.random.RandomGenerator;

public class CosineDistanceHash
extends LSHFunc {
    int dim;
    long seed;
    int repeat;
    int numHashes;

    public CosineDistanceHash(String sDim, String sRepeat, String sNumHashes, String sSeed) {
        super(sSeed);
        this.dim = Integer.parseInt(sDim);
        this.repeat = Integer.parseInt(sRepeat);
        this.numHashes = Integer.parseInt(sNumHashes);
    }

    public CosineDistanceHash(String sDim, String sRepeat, String sNumHashes) {
        this(sDim, sRepeat, sNumHashes, null);
    }

    @Override
    protected LSHCreator createLSHCreator() {
        return new LSHCreator(this.dim, this.numHashes, this.repeat, this.getSeed()){

            @Override
            protected LSH constructLSH(RandomGenerator rg) throws MathException {
                return new HyperplaneLSH(CosineDistanceHash.this.dim, rg);
            }
        };
    }

    @Override
    protected int getDimension() {
        return this.dim;
    }
}

