/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash.lsh;

import datafu.pig.hash.lsh.LSHFunc;
import datafu.pig.hash.lsh.interfaces.LSH;
import datafu.pig.hash.lsh.interfaces.LSHCreator;
import datafu.pig.hash.lsh.p_stable.L1LSH;
import org.apache.commons.math.MathException;
import org.apache.commons.math.random.RandomGenerator;

public class L1PStableHash
extends LSHFunc {
    int dim;
    double w;
    int repeat;
    int numHashes;

    public L1PStableHash(String sDim, String sW, String sRepeat, String sNumHashes, String sSeed) {
        super(sSeed);
        this.dim = Integer.parseInt(sDim);
        this.w = Double.parseDouble(sW);
        this.repeat = Integer.parseInt(sRepeat);
        this.numHashes = Integer.parseInt(sNumHashes);
    }

    public L1PStableHash(String sDim, String sW, String sRepeat, String sNumHashes) {
        this(sDim, sW, sRepeat, sNumHashes, null);
    }

    @Override
    protected LSHCreator createLSHCreator() {
        return new LSHCreator(this.dim, this.numHashes, this.repeat, this.getSeed()){

            @Override
            protected LSH constructLSH(RandomGenerator rg) throws MathException {
                return new L1LSH(L1PStableHash.this.dim, L1PStableHash.this.w, rg);
            }
        };
    }

    @Override
    protected int getDimension() {
        return this.dim;
    }
}

