/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash.lsh;

import datafu.pig.hash.lsh.LSHFunc;
import datafu.pig.hash.lsh.interfaces.LSH;
import datafu.pig.hash.lsh.interfaces.LSHCreator;
import datafu.pig.hash.lsh.p_stable.L2LSH;
import org.apache.commons.math.MathException;
import org.apache.commons.math.random.RandomGenerator;

public class L2PStableHash
extends LSHFunc {
    int dim;
    double w;
    long seed;
    int repeat;
    int numHashes;

    public L2PStableHash(String sDim, String sW, String sRepeat, String sNumHashes, String sSeed) {
        super(sSeed);
        this.dim = Integer.parseInt(sDim);
        this.w = Double.parseDouble(sW);
        this.repeat = Integer.parseInt(sRepeat);
        this.numHashes = Integer.parseInt(sNumHashes);
    }

    public L2PStableHash(String sDim, String sW, String sRepeat, String sNumHashes) {
        this(sDim, sW, sRepeat, sNumHashes, null);
    }

    @Override
    protected LSHCreator createLSHCreator() {
        return new LSHCreator(this.dim, this.numHashes, this.repeat, this.getSeed()){

            @Override
            protected LSH constructLSH(RandomGenerator rg) throws MathException {
                return new L2LSH(L2PStableHash.this.dim, L2PStableHash.this.w, rg);
            }
        };
    }

    @Override
    protected int getDimension() {
        return this.dim;
    }
}

