/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash.lsh;

import datafu.pig.hash.lsh.LSHFamily;
import datafu.pig.hash.lsh.interfaces.LSHCreator;
import datafu.pig.hash.lsh.util.DataTypeUtil;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.math.MathException;
import org.apache.commons.math.linear.RealVector;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.UDFContext;

public abstract class LSHFunc
extends EvalFunc<DataBag> {
    protected LSHFamily lsh = null;
    protected Long seed;
    private TupleFactory mTupleFactory = TupleFactory.getInstance();
    private BagFactory mBagFactory = BagFactory.getInstance();
    private LSHCreator lshCreator = null;

    protected abstract LSHCreator createLSHCreator();

    protected abstract int getDimension();

    public LSHFunc(String sSeed) {
        this.seed = sSeed == null ? null : Long.valueOf(Long.parseLong(sSeed));
    }

    public DataBag exec(Tuple t) throws IOException {
        if (this.lsh == null) {
            try {
                this.lshCreator = this.createLSHCreator();
                this.lsh = this.lshCreator.constructFamily(this.lshCreator.createGenerator());
            }
            catch (MathException e) {
                throw new RuntimeException("Unable to construct LSH!", e);
            }
        }
        RealVector r = null;
        try {
            r = DataTypeUtil.INSTANCE.convert(t, this.lshCreator.getDim());
        }
        catch (ExecException e) {
            throw new IllegalStateException("Unable to convert tuple: " + t.toString() + " to RealVector");
        }
        DataBag ret = this.mBagFactory.newDefaultBag();
        int idx = 0;
        for (Long hash : this.lsh.apply(r)) {
            Tuple out = this.mTupleFactory.newTuple(2);
            out.set(0, (Object)idx++);
            out.set(1, (Object)hash);
            ret.add(out);
        }
        return ret;
    }

    protected long getSeed() {
        if (this.seed == null) {
            UDFContext context = UDFContext.getUDFContext();
            return Long.parseLong(context.getUDFProperties(((Object)((Object)this)).getClass()).getProperty("seed"));
        }
        return this.seed;
    }

    public Schema outputSchema(Schema input) {
        try {
            this.validateInputSchema(input);
            long randomSeed = new Random().nextLong();
            UDFContext context = UDFContext.getUDFContext();
            context.getUDFProperties(((Object)((Object)this)).getClass()).setProperty("seed", "" + randomSeed);
            Schema bagSchema = new Schema();
            bagSchema.add(new Schema.FieldSchema("lsh_id", 10));
            bagSchema.add(new Schema.FieldSchema("hash", 15));
            return new Schema(new Schema.FieldSchema("lsh", bagSchema, 120));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create output schema", e);
        }
    }

    private void validateInputSchema(Schema input) throws FrontendException {
        Schema.FieldSchema vectorSchema = input.getField(0);
        if (!DataTypeUtil.isValidVector(vectorSchema, this.getDimension())) {
            throw new FrontendException("Invalid vector element: Expected either a tuple or a bag, but found " + vectorSchema);
        }
    }
}

