/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash.lsh;

import datafu.pig.hash.lsh.interfaces.LSH;
import java.util.List;
import org.apache.commons.math.MathException;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.commons.math.random.RandomGenerator;

public class RepeatingLSH
extends LSH {
    private List<LSH> lshList;
    private RealVector randomVec;

    public RepeatingLSH(List<LSH> lshList) throws MathException {
        super(lshList.get(0).getDim(), lshList.get(0).getRandomGenerator());
        this.lshList = lshList;
        RandomGenerator rg = lshList.get(0).getRandomGenerator();
        RandomDataImpl rd = new RandomDataImpl(rg);
        this.randomVec = new ArrayRealVector(lshList.size());
        for (int i = 0; i < this.randomVec.getDimension(); ++i) {
            this.randomVec.setEntry(i, rd.nextUniform(0.0, 10.0));
        }
    }

    @Override
    public long apply(RealVector vector) {
        long res = 0L;
        for (int i = 0; i < this.lshList.size(); ++i) {
            res = (long)((double)res + this.randomVec.getEntry(i) * (double)this.lshList.get(i).apply(vector));
        }
        return res;
    }
}

