/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash.lsh.cosine;

import datafu.pig.hash.lsh.interfaces.LSH;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.random.RandomGenerator;
import org.apache.commons.math.random.UnitSphereRandomVectorGenerator;

public class HyperplaneLSH
extends LSH {
    private RealVector r;

    public HyperplaneLSH(int dim, RandomGenerator rg) {
        super(dim, rg);
        UnitSphereRandomVectorGenerator generator = new UnitSphereRandomVectorGenerator(dim, rg);
        double[] normalVector = generator.nextVector();
        this.r = new ArrayRealVector(normalVector);
    }

    @Override
    public long apply(RealVector vector) {
        return this.r.dotProduct(vector) >= 0.0 ? 1L : 0L;
    }
}

