/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash.lsh.interfaces;

import datafu.pig.hash.lsh.LSHFamily;
import datafu.pig.hash.lsh.RepeatingLSH;
import datafu.pig.hash.lsh.interfaces.LSH;
import java.util.ArrayList;
import org.apache.commons.math.MathException;
import org.apache.commons.math.random.JDKRandomGenerator;
import org.apache.commons.math.random.RandomGenerator;

public abstract class LSHCreator {
    private int dim;
    private int numHashes;
    private int numInternalRepetitions;
    private long seed;

    public LSHCreator(int dim, int numHashes, int numInternalRepetitions, long seed) {
        this.dim = dim;
        this.numHashes = numHashes;
        this.numInternalRepetitions = numInternalRepetitions;
        this.seed = seed;
    }

    protected abstract LSH constructLSH(RandomGenerator var1) throws MathException;

    public int getDim() {
        return this.dim;
    }

    public RandomGenerator createGenerator() {
        JDKRandomGenerator rg = new JDKRandomGenerator();
        rg.setSeed(this.seed);
        return rg;
    }

    public int getNumHashes() {
        return this.numHashes;
    }

    public int getNumInternalRepetitions() {
        return this.numInternalRepetitions;
    }

    public LSHFamily constructFamily(RandomGenerator rg) throws MathException {
        ArrayList<LSH> hashes = new ArrayList<LSH>();
        for (int i = 0; i < this.getNumHashes(); ++i) {
            LSH lsh = null;
            if (this.getNumInternalRepetitions() == 1) {
                lsh = this.constructLSH(rg);
            } else {
                ArrayList<LSH> lshFamily = new ArrayList<LSH>();
                for (int j = 0; j < this.getNumInternalRepetitions(); ++j) {
                    lshFamily.add(this.constructLSH(rg));
                }
                lsh = new RepeatingLSH(lshFamily);
            }
            hashes.add(lsh);
        }
        return new LSHFamily(hashes);
    }
}

