/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash.lsh.metric;

import datafu.pig.hash.lsh.util.DataTypeUtil;
import java.io.IOException;
import org.apache.commons.math.linear.RealVector;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public abstract class MetricUDF
extends EvalFunc<Tuple> {
    protected int dim;

    public MetricUDF(String sDim) {
        this.dim = Integer.parseInt(sDim);
    }

    protected abstract double dist(RealVector var1, RealVector var2);

    public Tuple exec(Tuple input) throws IOException {
        Object firstElement = input.get(0);
        double distanceRange = ((Number)input.get(1)).doubleValue();
        DataBag vectorBag = (DataBag)input.get(2);
        RealVector referenceVector = null;
        referenceVector = firstElement instanceof Tuple ? DataTypeUtil.INSTANCE.convert((Tuple)firstElement, this.dim) : DataTypeUtil.INSTANCE.convert(input, this.dim);
        for (Tuple vecTuple : vectorBag) {
            Object vectorObj = vecTuple.get(0);
            RealVector v2 = null;
            v2 = vectorObj instanceof Tuple ? DataTypeUtil.INSTANCE.convert((Tuple)vecTuple.get(0), referenceVector.getDimension()) : DataTypeUtil.INSTANCE.convert(vecTuple, referenceVector.getDimension());
            double dist = this.dist(referenceVector, v2);
            if (!(dist < distanceRange)) continue;
            return vecTuple;
        }
        return null;
    }

    public Schema outputSchema(Schema input) {
        try {
            this.validateInputSchema(input);
            Schema.FieldSchema fieldSchema = input.getField(2);
            return fieldSchema.schema;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create output schema", e);
        }
    }

    private void validateInputSchema(Schema input) throws FrontendException {
        Schema.FieldSchema vectorSchema = input.getField(0);
        if (!DataTypeUtil.isValidVector(vectorSchema, this.dim)) {
            throw new FrontendException("Invalid vector element: Expected either a tuple or a bag, but found " + vectorSchema);
        }
        Schema.FieldSchema distanceSchema = input.getField(1);
        if (distanceSchema.type != 25 && distanceSchema.type != 10 && distanceSchema.type != 15) {
            throw new FrontendException("Invalid distance element: Expected a number, but found " + distanceSchema);
        }
        Schema.FieldSchema pointsSchema = input.getField(2);
        if (pointsSchema.type != 120) {
            throw new FrontendException("Invalid points element: Expected a bag, but found " + pointsSchema);
        }
        Schema.FieldSchema tupleInBag = pointsSchema.schema.getField(0);
        Schema.FieldSchema vectorInTuple = tupleInBag.schema.getField(0);
        if (!DataTypeUtil.isValidVector(vectorInTuple, this.dim)) {
            throw new FrontendException("Invalid points element: Expected a bag of vectors, but found " + vectorInTuple.schema);
        }
    }
}

