/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash.lsh.p_stable;

import datafu.pig.hash.lsh.interfaces.LSH;
import datafu.pig.hash.lsh.interfaces.Sampler;
import org.apache.commons.math.MathException;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.commons.math.random.RandomGenerator;

public abstract class AbstractStableDistributionFunction
extends LSH {
    private double[] a;
    private double b;
    double w;

    public AbstractStableDistributionFunction(int dim, double w, RandomGenerator rand) throws MathException {
        super(dim, rand);
        this.reset(dim, w);
    }

    public void reset(int dim, double w) throws MathException {
        RandomDataImpl dataSampler = new RandomDataImpl(this.rg);
        Sampler sampler = this.getSampler();
        this.a = new double[dim];
        this.dim = dim;
        this.w = w;
        for (int i = 0; i < dim; ++i) {
            this.a[i] = sampler.sample(dataSampler);
        }
        this.b = dataSampler.nextUniform(0.0, w);
    }

    protected abstract Sampler getSampler();

    @Override
    public long apply(RealVector vector) {
        double ret = this.b;
        for (int i = 0; i < this.dim; ++i) {
            ret += vector.getEntry(i) * this.a[i];
        }
        return (long)Math.floor(ret / this.w);
    }
}

