/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.hash.lsh.util;

import java.util.List;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.OpenMapRealVector;
import org.apache.commons.math.linear.RealVector;
import org.apache.pig.PigException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public enum DataTypeUtil {
    INSTANCE;


    public RealVector convert(Tuple t, int dim) throws PigException {
        Object firstElement = t.get(0);
        if (firstElement instanceof DataBag) {
            return this.convertBag((DataBag)firstElement, dim);
        }
        if (firstElement instanceof Number) {
            return this.convertTuple(t, dim);
        }
        if (firstElement instanceof Tuple) {
            return this.convert((Tuple)firstElement, dim);
        }
        throw new PigException("Unable to convert tuple into a RealVector.  I expected either a tuple of numeric types or a Bag of tuples with positions and values.");
    }

    private RealVector convertTuple(Tuple t, int dim) throws PigException {
        double[] values = new double[dim];
        for (int i = 0; i < t.size(); ++i) {
            values[i] = ((Number)t.get(i)).doubleValue();
        }
        return new ArrayRealVector(values);
    }

    private RealVector convertBag(DataBag bag, int dim) throws PigException {
        OpenMapRealVector ret = new OpenMapRealVector(dim);
        for (Tuple t : bag) {
            if (t.size() != 2) {
                throw new PigException("Unable to convert tuple inside bag into a sparse vector.  Expected tuples of size at least 2 of form (int, java.lang.Number)");
            }
            Integer position = (Integer)t.get(0);
            double value = ((Number)t.get(1)).doubleValue();
            ret.setEntry(position.intValue(), value);
        }
        return ret;
    }

    private static boolean isValidDenseVector(Schema.FieldSchema vectorSchema, int dimension) {
        List innerFields = vectorSchema.schema.getFields();
        if (innerFields.size() != dimension) {
            return false;
        }
        for (Schema.FieldSchema innerField : innerFields) {
            if (innerField.type == 10 || innerField.type == 25 || innerField.type == 15 || innerField.type == 20) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidSparseVector(Schema.FieldSchema vectorSchema) {
        Schema.FieldSchema tupleSchema = (Schema.FieldSchema)vectorSchema.schema.getFields().get(0);
        if (tupleSchema.type != 110) {
            return false;
        }
        List innerFields = tupleSchema.schema.getFields();
        if (innerFields.size() != 2) {
            return false;
        }
        Schema.FieldSchema indexField = (Schema.FieldSchema)innerFields.get(0);
        if (indexField.type != 15 && indexField.type != 10) {
            return false;
        }
        Schema.FieldSchema valueField = (Schema.FieldSchema)innerFields.get(1);
        return valueField.type == 25 || valueField.type == 20;
    }

    public static boolean isValidVector(Schema.FieldSchema inputSchema, int dimension) {
        Schema.FieldSchema vectorSchema = inputSchema;
        if (vectorSchema.type == 110) {
            List children = vectorSchema.schema.getFields();
            while (children.size() > 0 && ((Schema.FieldSchema)children.get((int)0)).type == 110) {
                vectorSchema = (Schema.FieldSchema)children.get(0);
                children = vectorSchema.schema.getFields();
            }
        }
        if (vectorSchema.type == 120) {
            return DataTypeUtil.isValidSparseVector(vectorSchema);
        }
        if (vectorSchema.type == 110) {
            return DataTypeUtil.isValidDenseVector(vectorSchema, dimension);
        }
        return false;
    }
}

