/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.linkanalysis;

import datafu.pig.linkanalysis.PageRankImpl;
import datafu.pig.linkanalysis.ProgressIndicator;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class PageRank
extends AccumulatorEvalFunc<DataBag> {
    private final PageRankImpl graph = new PageRankImpl();
    private int maxNodesAndEdges = 100000000;
    private int maxEdgesInMemory = 30000000;
    private double tolerance = 1.0E-16;
    private int maxIters = 150;
    private boolean useEdgeDiskStorage = false;
    private boolean enableDanglingNodeHandling = false;
    private boolean enableNodeBiasing = false;
    private boolean aborted = false;
    private float alpha = 0.85f;
    TupleFactory tupleFactory = TupleFactory.getInstance();
    BagFactory bagFactory = BagFactory.getInstance();

    public PageRank() {
        this.initialize();
    }

    public PageRank(String ... parameters) {
        if (parameters.length % 2 != 0) {
            throw new RuntimeException("Invalid parameters list");
        }
        for (int i = 0; i < parameters.length; i += 2) {
            String parameterName = parameters[i];
            String value = parameters[i + 1];
            if (parameterName.equals("max_nodes_and_edges")) {
                this.maxNodesAndEdges = Integer.parseInt(value);
                continue;
            }
            if (parameterName.equals("max_edges_in_memory")) {
                this.maxEdgesInMemory = Integer.parseInt(value);
                continue;
            }
            if (parameterName.equals("tolerance")) {
                this.tolerance = Double.parseDouble(value);
                continue;
            }
            if (parameterName.equals("max_iters")) {
                this.maxIters = Integer.parseInt(value);
                continue;
            }
            if (parameterName.equals("spill_to_edge_disk_storage")) {
                this.useEdgeDiskStorage = Boolean.parseBoolean(value);
                continue;
            }
            if (parameterName.equals("dangling_nodes")) {
                this.enableDanglingNodeHandling = Boolean.parseBoolean(value);
                continue;
            }
            if (parameterName.equals("node_biasing")) {
                this.enableNodeBiasing = Boolean.parseBoolean(value);
                continue;
            }
            if (!parameterName.equals("alpha")) continue;
            this.alpha = Float.parseFloat(value);
        }
        this.initialize();
    }

    private void initialize() {
        if (this.useEdgeDiskStorage) {
            this.graph.enableEdgeDiskCaching();
        } else {
            this.graph.disableEdgeDiskCaching();
        }
        if (this.enableDanglingNodeHandling) {
            this.graph.enableDanglingNodeHandling();
        } else {
            this.graph.disableDanglingNodeHandling();
        }
        if (this.enableNodeBiasing) {
            this.graph.enableNodeBiasing();
        } else {
            this.graph.disableNodeBiasing();
        }
        this.graph.setEdgeCachingThreshold(this.maxEdgesInMemory);
        this.graph.setAlpha(this.alpha);
    }

    public void accumulate(Tuple t) throws IOException {
        if (this.aborted) {
            return;
        }
        DataBag bag = (DataBag)t.get(0);
        if (bag == null || bag.size() == 0L) {
            return;
        }
        for (Tuple sourceTuple : bag) {
            Integer sourceId = (Integer)sourceTuple.get(0);
            DataBag edges = (DataBag)sourceTuple.get(1);
            Double nodeBias = null;
            if (this.enableNodeBiasing) {
                nodeBias = (Double)sourceTuple.get(2);
            }
            ArrayList<Map<String, Object>> edgesMapList = new ArrayList<Map<String, Object>>();
            for (Tuple edgeTuple : edges) {
                Integer destId = (Integer)edgeTuple.get(0);
                Double weight = (Double)edgeTuple.get(1);
                HashMap<String, Number> edgeMap = new HashMap<String, Number>();
                edgeMap.put("dest", destId);
                edgeMap.put("weight", weight);
                edgesMapList.add(edgeMap);
            }
            if (this.enableNodeBiasing) {
                this.graph.addNode(sourceId, edgesMapList, nodeBias.floatValue());
            } else {
                this.graph.addNode(sourceId, edgesMapList);
            }
            if (this.graph.nodeCount() + this.graph.edgeCount() > (long)this.maxNodesAndEdges) {
                System.out.println(String.format("There are too many nodes and edges (%d + %d > %d). Aborting.", this.graph.nodeCount(), this.graph.edgeCount(), this.maxNodesAndEdges));
                this.aborted = true;
                break;
            }
            this.reporter.progress();
        }
    }

    public DataBag getValue() {
        float totalDiff;
        if (this.aborted) {
            return null;
        }
        System.out.println(String.format("Nodes: %d, Edges: %d", this.graph.nodeCount(), this.graph.edgeCount()));
        ProgressIndicator progressIndicator = this.getProgressIndicator();
        System.out.println("Finished loading graph.");
        long startTime = System.nanoTime();
        System.out.println("Initializing.");
        try {
            this.graph.init(progressIndicator);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        System.out.println(String.format("Done, took %f ms", (double)(System.nanoTime() - startTime) / 1.0E7));
        int iter = 0;
        System.out.println("Beginning iterations");
        startTime = System.nanoTime();
        do {
            try {
                totalDiff = this.graph.nextIteration(progressIndicator);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        } while (++iter < this.maxIters && (double)totalDiff > this.tolerance);
        System.out.println(String.format("Done, %d iterations took %f ms", iter, (double)(System.nanoTime() - startTime) / 1.0E7));
        DataBag output = this.bagFactory.newDefaultBag();
        for (Int2IntMap.Entry node : this.graph.getNodeIds()) {
            int nodeId = node.getIntKey();
            float rank = this.graph.getNodeRank(nodeId);
            ArrayList<Number> nodeData = new ArrayList<Number>(2);
            nodeData.add(nodeId);
            nodeData.add(Float.valueOf(rank));
            output.add(this.tupleFactory.newTuple(nodeData));
        }
        return output;
    }

    public void cleanup() {
        try {
            this.aborted = false;
            this.graph.clear();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ProgressIndicator getProgressIndicator() {
        return new ProgressIndicator(){

            @Override
            public void progress() {
                PageRank.this.reporter.progress();
            }
        };
    }

    public Schema outputSchema(Schema input) {
        try {
            Schema.FieldSchema inputFieldSchema = input.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            Schema inputBagSchema = inputFieldSchema.schema;
            if (inputBagSchema.getField((int)0).type != 110) {
                throw new RuntimeException(String.format("Expected input bag to contain a TUPLE, but instead found %s", DataType.findTypeName((byte)inputBagSchema.getField((int)0).type)));
            }
            Schema inputTupleSchema = inputBagSchema.getField((int)0).schema;
            if (!this.enableNodeBiasing) {
                if (inputTupleSchema.size() != 2) {
                    throw new RuntimeException("Expected two fields for the node data");
                }
            } else if (inputTupleSchema.size() != 3) {
                throw new RuntimeException("Expected three fields for the node data");
            }
            if (inputTupleSchema.getField((int)0).type != 10) {
                throw new RuntimeException(String.format("Expected source to be an INTEGER, but instead found %s", DataType.findTypeName((byte)inputTupleSchema.getField((int)0).type)));
            }
            if (inputTupleSchema.getField((int)1).type != 120) {
                throw new RuntimeException(String.format("Expected edges to be represented with a BAG", new Object[0]));
            }
            if (this.enableNodeBiasing && inputTupleSchema.getField((int)2).type != 25) {
                throw new RuntimeException(String.format("Expected node bias to be a DOUBLE, but instead found %s", DataType.findTypeName((byte)inputTupleSchema.getField((int)2).type)));
            }
            Schema.FieldSchema edgesFieldSchema = inputTupleSchema.getField(1);
            if (edgesFieldSchema.schema.getField((int)0).type != 110) {
                throw new RuntimeException(String.format("Expected edges field to contain a TUPLE, but instead found %s", DataType.findTypeName((byte)edgesFieldSchema.schema.getField((int)0).type)));
            }
            Schema edgesTupleSchema = edgesFieldSchema.schema.getField((int)0).schema;
            if (edgesTupleSchema.size() != 2) {
                throw new RuntimeException("Expected two fields for the edge data");
            }
            if (edgesTupleSchema.getField((int)0).type != 10) {
                throw new RuntimeException(String.format("Expected destination edge ID to an INTEGER, but instead found %s", DataType.findTypeName((byte)edgesTupleSchema.getField((int)0).type)));
            }
            if (edgesTupleSchema.getField((int)1).type != 25) {
                throw new RuntimeException(String.format("Expected destination edge weight to a DOUBLE, but instead found %s", DataType.findTypeName((byte)edgesTupleSchema.getField((int)1).type)));
            }
            Schema tupleSchema = new Schema();
            tupleSchema.add(new Schema.FieldSchema("node", 10));
            tupleSchema.add(new Schema.FieldSchema("rank", 20));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 120));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

