/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.linkanalysis;

import com.google.common.collect.AbstractIterator;
import datafu.pig.linkanalysis.ProgressIndicator;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class PageRankImpl {
    private float totalRankChange;
    private long edgeCount;
    private long nodeCount;
    private float alpha = 0.85f;
    private static float EDGE_WEIGHT_MULTIPLIER = 100000.0f;
    private final Int2IntOpenHashMap nodeIndices = new Int2IntOpenHashMap();
    private final FloatArrayList nodeData = new FloatArrayList();
    private int nodeFieldCount = 3;
    private final IntArrayList danglingNodes = new IntArrayList();
    private final IntArrayList edges = new IntArrayList();
    private boolean shouldHandleDanglingNodes = false;
    private boolean shouldCacheEdgesOnDisk = false;
    private long edgeCachingThreshold;
    private boolean nodeBiasingEnabled = false;
    private File edgesFile;
    private DataOutputStream edgeDataOutputStream;
    private boolean usingEdgeDiskCache;

    public void clear() throws IOException {
        this.edgeCount = 0L;
        this.nodeCount = 0L;
        this.totalRankChange = 0.0f;
        this.nodeIndices.clear();
        this.nodeData.clear();
        this.edges.clear();
        this.danglingNodes.clear();
        if (this.edgeDataOutputStream != null) {
            this.edgeDataOutputStream.close();
            this.edgeDataOutputStream = null;
        }
        this.usingEdgeDiskCache = false;
        this.edgesFile = null;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public boolean isNodeBiasingEnabled() {
        return this.nodeBiasingEnabled;
    }

    public void enableNodeBiasing() {
        this.nodeBiasingEnabled = true;
        this.nodeFieldCount = 4;
    }

    public void disableNodeBiasing() {
        this.nodeBiasingEnabled = false;
        this.nodeFieldCount = 3;
    }

    public boolean isUsingEdgeDiskCache() {
        return this.usingEdgeDiskCache;
    }

    public void enableEdgeDiskCaching() {
        this.shouldCacheEdgesOnDisk = true;
    }

    public void disableEdgeDiskCaching() {
        this.shouldCacheEdgesOnDisk = false;
    }

    public boolean isEdgeDiskCachingEnabled() {
        return this.shouldCacheEdgesOnDisk;
    }

    public long getEdgeCachingThreshold() {
        return this.edgeCachingThreshold;
    }

    public void setEdgeCachingThreshold(long count) {
        this.edgeCachingThreshold = count;
    }

    public void enableDanglingNodeHandling() {
        this.shouldHandleDanglingNodes = true;
    }

    public void disableDanglingNodeHandling() {
        this.shouldHandleDanglingNodes = false;
    }

    public long nodeCount() {
        return this.nodeCount;
    }

    public long edgeCount() {
        return this.edgeCount;
    }

    public Int2IntMap.FastEntrySet getNodeIds() {
        return this.nodeIndices.int2IntEntrySet();
    }

    public float getNodeRank(int nodeId) {
        int nodeIndex = this.nodeIndices.get(nodeId);
        return this.nodeData.get(nodeIndex).floatValue();
    }

    public float getTotalRankChange() {
        return this.totalRankChange;
    }

    private void maybeCreateNode(int nodeId) {
        if (!this.nodeIndices.containsKey(nodeId)) {
            int index = this.nodeData.size();
            this.nodeData.add(0.0f);
            this.nodeData.add(0.0f);
            this.nodeData.add(0.0f);
            if (this.nodeBiasingEnabled) {
                this.nodeData.add(0.0f);
            }
            this.nodeIndices.put(nodeId, index);
            ++this.nodeCount;
        }
    }

    public float getNodeBias(int nodeId) {
        if (!this.nodeBiasingEnabled) {
            throw new IllegalArgumentException("Node biasing not enable");
        }
        int nodeIndex = this.nodeIndices.get(nodeId);
        return this.nodeData.get(nodeIndex + 3).floatValue();
    }

    public void setNodeBias(int nodeId, float bias) {
        if (!this.nodeBiasingEnabled) {
            throw new IllegalArgumentException("Node biasing not enable");
        }
        int nodeIndex = this.nodeIndices.get(nodeId);
        this.nodeData.set(nodeIndex + 3, bias);
    }

    public void addNode(Integer sourceId, ArrayList<Map<String, Object>> sourceEdges) throws IOException {
        this.addNode(sourceId, sourceEdges, 1.0f);
    }

    public void addNode(Integer sourceId, ArrayList<Map<String, Object>> sourceEdges, float bias) throws IOException {
        int source = sourceId;
        this.maybeCreateNode(source);
        if (this.nodeBiasingEnabled) {
            this.setNodeBias(source, bias);
        } else if (bias != 1.0f) {
            throw new IllegalArgumentException("Bias was specified but node biasing not enabled");
        }
        if (this.shouldCacheEdgesOnDisk && !this.usingEdgeDiskCache && (long)sourceEdges.size() + this.edgeCount >= this.edgeCachingThreshold) {
            this.writeEdgesToDisk();
        }
        this.appendEdgeData(source);
        this.appendEdgeData(sourceEdges.size());
        for (Map<String, Object> edge : sourceEdges) {
            int dest = (Integer)edge.get("dest");
            float weight = ((Double)edge.get("weight")).floatValue();
            this.maybeCreateNode(dest);
            this.appendEdgeData(dest);
            this.appendEdgeData(Math.max(1, (int)(weight * EDGE_WEIGHT_MULTIPLIER)));
            ++this.edgeCount;
        }
    }

    private void appendEdgeData(int data) throws IOException {
        if (this.edgeDataOutputStream != null) {
            this.edgeDataOutputStream.writeInt(data);
        } else {
            this.edges.add(data);
        }
    }

    public void init() throws IOException {
        this.init(this.getDummyIndicator());
    }

    public void init(ProgressIndicator progressIndicator) throws IOException {
        float totalWeight;
        int nodeIndex;
        int j;
        if (this.edgeDataOutputStream != null) {
            this.edgeDataOutputStream.close();
            this.edgeDataOutputStream = null;
        }
        float nodeRank = 1.0f / (float)this.nodeCount;
        float totalBias = 0.0f;
        for (j = 0; j < this.nodeData.size(); j += this.nodeFieldCount) {
            this.nodeData.set(j, nodeRank);
            progressIndicator.progress();
            if (!this.nodeBiasingEnabled) continue;
            totalBias += this.nodeData.getFloat(j + 3);
        }
        if (this.nodeBiasingEnabled) {
            for (j = 0; j < this.nodeData.size(); j += this.nodeFieldCount) {
                float bias = this.nodeData.getFloat(j + 3);
                this.nodeData.set(j + 3, bias /= totalBias);
            }
        }
        Iterator<Integer> edgeData = this.getEdgeData();
        while (edgeData.hasNext()) {
            int sourceId = edgeData.next();
            int nodeEdgeCount = edgeData.next();
            while (nodeEdgeCount-- > 0) {
                edgeData.next();
                float weight = edgeData.next().intValue();
                nodeIndex = this.nodeIndices.get(sourceId);
                totalWeight = this.nodeData.getFloat(nodeIndex + 1);
                this.nodeData.set(nodeIndex + 1, totalWeight += weight);
                progressIndicator.progress();
            }
        }
        if (this.shouldHandleDanglingNodes) {
            for (Map.Entry e : this.nodeIndices.entrySet()) {
                int nodeId = (Integer)e.getKey();
                nodeIndex = (Integer)e.getValue();
                totalWeight = this.nodeData.getFloat(nodeIndex + 1);
                if (totalWeight != 0.0f) continue;
                this.danglingNodes.add(nodeId);
            }
        }
    }

    public float nextIteration(ProgressIndicator progressIndicator) throws IOException {
        this.distribute(progressIndicator);
        this.commit(progressIndicator);
        return this.getTotalRankChange();
    }

    public float nextIteration() throws IOException {
        ProgressIndicator dummyIndicator = this.getDummyIndicator();
        this.distribute(dummyIndicator);
        this.commit(dummyIndicator);
        return this.getTotalRankChange();
    }

    private ProgressIndicator getDummyIndicator() {
        return new ProgressIndicator(){

            @Override
            public void progress() {
            }
        };
    }

    public void distribute(ProgressIndicator progressIndicator) throws IOException {
        Iterator<Integer> edgeData = this.getEdgeData();
        while (edgeData.hasNext()) {
            int sourceId = edgeData.next();
            int nodeEdgeCount = edgeData.next();
            while (nodeEdgeCount-- > 0) {
                int toId = edgeData.next();
                float weight = edgeData.next().intValue();
                int fromNodeIndex = this.nodeIndices.get(sourceId);
                int toNodeIndex = this.nodeIndices.get(toId);
                float contributionChange = weight * this.nodeData.getFloat(fromNodeIndex) / this.nodeData.getFloat(fromNodeIndex + 1);
                float currentContribution = this.nodeData.getFloat(toNodeIndex + 2);
                this.nodeData.set(toNodeIndex + 2, currentContribution + contributionChange);
                progressIndicator.progress();
            }
        }
        if (this.shouldHandleDanglingNodes) {
            float totalRank = 0.0f;
            IntListIterator nodeEdgeCount = this.danglingNodes.iterator();
            while (nodeEdgeCount.hasNext()) {
                int nodeId = (Integer)nodeEdgeCount.next();
                int nodeIndex = this.nodeIndices.get(nodeId);
                float rank = this.nodeData.get(nodeIndex).floatValue();
                totalRank += rank;
            }
            float contributionIncrease = totalRank / (float)this.nodeCount;
            for (int i = 2; i < this.nodeData.size(); i += this.nodeFieldCount) {
                float contribution = this.nodeData.getFloat(i);
                this.nodeData.set(i, contribution += contributionIncrease);
            }
        }
    }

    public void commit(ProgressIndicator progressIndicator) {
        this.totalRankChange = 0.0f;
        float oneMinusAlpha = 1.0f - this.alpha;
        float oneMinusAlphaOverNodeCount = oneMinusAlpha / (float)this.nodeCount;
        for (int nodeIndex = 0; nodeIndex < this.nodeData.size(); nodeIndex += this.nodeFieldCount) {
            float newRank;
            float oldRank = this.nodeData.get(nodeIndex + 2).floatValue();
            if (this.nodeBiasingEnabled) {
                float bias = this.nodeData.get(nodeIndex + 3).floatValue();
                newRank = bias * oneMinusAlpha + this.alpha * oldRank;
            } else {
                newRank = oneMinusAlphaOverNodeCount + this.alpha * oldRank;
            }
            this.nodeData.set(nodeIndex + 2, 0.0f);
            float lastRankDiff = newRank - this.nodeData.get(nodeIndex).floatValue();
            this.nodeData.set(nodeIndex, newRank);
            this.totalRankChange += Math.abs(lastRankDiff);
            progressIndicator.progress();
        }
    }

    private void writeEdgesToDisk() throws IOException {
        this.edgesFile = File.createTempFile("fastgraph", null);
        FileOutputStream outStream = new FileOutputStream(this.edgesFile);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(outStream);
        this.edgeDataOutputStream = new DataOutputStream(bufferedStream);
        IntListIterator intListIterator = this.edges.iterator();
        while (intListIterator.hasNext()) {
            int edgeData = (Integer)intListIterator.next();
            this.edgeDataOutputStream.writeInt(edgeData);
        }
        this.edges.clear();
        this.usingEdgeDiskCache = true;
    }

    private Iterator<Integer> getEdgeData() throws IOException {
        if (!this.usingEdgeDiskCache) {
            return this.edges.iterator();
        }
        FileInputStream fileInputStream = new FileInputStream(this.edgesFile);
        BufferedInputStream inputStream = new BufferedInputStream(fileInputStream);
        final DataInputStream dataInputStream = new DataInputStream(inputStream);
        return new AbstractIterator<Integer>(){

            protected Integer computeNext() {
                try {
                    return dataInputStream.readInt();
                }
                catch (IOException e) {
                    return (Integer)this.endOfData();
                }
            }
        };
    }
}

