/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.sampling;

import datafu.pig.sampling.Reservoir;
import datafu.pig.sampling.ScoredTuple;
import java.io.IOException;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.builtin.Nondeterministic;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

@Nondeterministic
public class ReservoirSample
extends AccumulatorEvalFunc<DataBag>
implements Algebraic {
    protected Integer numSamples;
    private Reservoir reservoir;
    protected ScoredTuple.ScoreGenerator scoreGen;
    String param = null;

    private Reservoir getReservoir() {
        if (this.reservoir == null) {
            this.reservoir = new Reservoir(this.numSamples);
        }
        return this.reservoir;
    }

    public ReservoirSample(String numSamples) {
        this.numSamples = Integer.parseInt(numSamples);
    }

    protected ScoredTuple.ScoreGenerator getScoreGenerator() {
        if (this.scoreGen == null) {
            this.scoreGen = new ScoredTuple.PureRandomScoreGenerator();
        }
        return this.scoreGen;
    }

    public void accumulate(Tuple input) throws IOException {
        DataBag samples = (DataBag)input.get(0);
        ScoredTuple.ScoreGenerator scoreGen = this.getScoreGenerator();
        for (Tuple sample : samples) {
            this.getReservoir().consider(new ScoredTuple(scoreGen.generateScore(sample), sample));
        }
    }

    public void cleanup() {
        this.reservoir.clear();
    }

    public DataBag getValue() {
        DataBag output = BagFactory.getInstance().newDefaultBag();
        for (ScoredTuple sample : this.getReservoir()) {
            output.add(sample.getTuple());
        }
        return output;
    }

    public DataBag exec(Tuple input) throws IOException {
        DataBag samples = (DataBag)input.get(0);
        if (samples.size() <= (long)this.numSamples.intValue()) {
            return samples;
        }
        return (DataBag)super.exec(input);
    }

    public Schema outputSchema(Schema input) {
        try {
            Schema.FieldSchema inputFieldSchema = input.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), inputFieldSchema.schema, 120));
        }
        catch (FrontendException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String getParam() {
        if (this.param == null) {
            this.param = this.numSamples != null ? String.format("('%d')", this.numSamples) : "";
        }
        return this.param;
    }

    public String getInitial() {
        return Initial.class.getName() + this.getParam();
    }

    public String getIntermed() {
        return Intermediate.class.getName() + this.getParam();
    }

    public String getFinal() {
        return Final.class.getName() + this.getParam();
    }

    public static class Final
    extends EvalFunc<DataBag> {
        int numSamples;
        private Reservoir reservoir;
        TupleFactory tupleFactory = TupleFactory.getInstance();

        public Final() {
        }

        public Final(String numSamples) {
            this.numSamples = Integer.parseInt(numSamples);
        }

        private Reservoir getReservoir() {
            if (this.reservoir == null) {
                this.reservoir = new Reservoir(this.numSamples);
            }
            return this.reservoir;
        }

        public DataBag exec(Tuple input) throws IOException {
            this.getReservoir().clear();
            DataBag bagOfSamples = (DataBag)input.get(0);
            for (Tuple innerTuple : bagOfSamples) {
                DataBag samples = (DataBag)innerTuple.get(0);
                for (Tuple sample : samples) {
                    this.getReservoir().consider(ScoredTuple.fromIntermediateTuple(sample));
                }
            }
            DataBag output = BagFactory.getInstance().newDefaultBag();
            for (ScoredTuple scoredTuple : this.getReservoir()) {
                output.add(scoredTuple.getTuple());
            }
            return output;
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        int numSamples;
        private Reservoir reservoir;
        TupleFactory tupleFactory = TupleFactory.getInstance();

        public Intermediate() {
        }

        public Intermediate(String numSamples) {
            this.numSamples = Integer.parseInt(numSamples);
        }

        private Reservoir getReservoir() {
            if (this.reservoir == null) {
                this.reservoir = new Reservoir(this.numSamples);
            }
            return this.reservoir;
        }

        public Tuple exec(Tuple input) throws IOException {
            this.getReservoir().clear();
            DataBag bagOfSamples = (DataBag)input.get(0);
            for (Tuple innerTuple : bagOfSamples) {
                DataBag samples = (DataBag)innerTuple.get(0);
                for (Tuple sample : samples) {
                    this.getReservoir().consider(ScoredTuple.fromIntermediateTuple(sample));
                }
            }
            DataBag output = BagFactory.getInstance().newDefaultBag();
            for (ScoredTuple scoredTuple : this.getReservoir()) {
                output.add(scoredTuple.getIntermediateTuple(this.tupleFactory));
            }
            return this.tupleFactory.newTuple((Object)output);
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        int numSamples;
        private Reservoir reservoir;
        protected ScoredTuple.ScoreGenerator scoreGen;
        TupleFactory tupleFactory = TupleFactory.getInstance();

        public Initial() {
        }

        public Initial(String numSamples) {
            this.numSamples = Integer.parseInt(numSamples);
        }

        private Reservoir getReservoir() {
            if (this.reservoir == null) {
                this.reservoir = new Reservoir(this.numSamples);
            }
            return this.reservoir;
        }

        protected ScoredTuple.ScoreGenerator getScoreGenerator() {
            if (this.scoreGen == null) {
                this.scoreGen = new ScoredTuple.PureRandomScoreGenerator();
            }
            return this.scoreGen;
        }

        public Tuple exec(Tuple input) throws IOException {
            DataBag output;
            block5: {
                output = BagFactory.getInstance().newDefaultBag();
                ScoredTuple.ScoreGenerator scoreGen = this.getScoreGenerator();
                DataBag samples = (DataBag)input.get(0);
                if (samples == null) break block5;
                if (samples.size() <= (long)this.numSamples) {
                    for (Tuple sample : samples) {
                        output.add(new ScoredTuple(scoreGen.generateScore(sample), sample).getIntermediateTuple(this.tupleFactory));
                    }
                } else {
                    this.getReservoir().clear();
                    for (Tuple sample : samples) {
                        this.getReservoir().consider(new ScoredTuple(scoreGen.generateScore(sample), sample));
                    }
                    for (ScoredTuple scoredTuple : this.getReservoir()) {
                        output.add(scoredTuple.getIntermediateTuple(this.tupleFactory));
                    }
                }
            }
            return this.tupleFactory.newTuple((Object)output);
        }
    }
}

