/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.sampling;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.pig.FilterFunc;
import org.apache.pig.data.Tuple;

public class SampleByKey
extends FilterFunc {
    static final int PRIME_NUMBER = 31;
    Integer seed = null;
    double probability;

    public SampleByKey(String probability) {
        this.probability = Double.parseDouble(probability);
    }

    public SampleByKey(String probability, String salt) {
        this(probability);
        this.seed = salt.hashCode();
    }

    public void setUDFContextSignature(String signature) {
        if (this.seed == null && signature != null) {
            this.seed = signature.hashCode();
        }
        super.setUDFContextSignature(signature);
    }

    public Boolean exec(Tuple input) throws IOException {
        int hashCode = 0;
        for (int i = 0; i < input.size(); ++i) {
            Object each = input.get(i);
            hashCode = hashCode * 31 + each.hashCode();
        }
        try {
            return this.intToRandomDouble(hashCode) <= this.probability;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Exception on intToRandomDouble");
        }
    }

    private Double intToRandomDouble(int input) throws Exception {
        MessageDigest hasher = MessageDigest.getInstance("sha-1");
        ByteBuffer b = ByteBuffer.allocate(8);
        ByteBuffer b2 = ByteBuffer.allocate(20);
        b.putInt(this.seed == null ? 31 : this.seed);
        b.putInt(input);
        byte[] digest = hasher.digest(b.array());
        b.clear();
        b2.put(digest);
        b2.rewind();
        double result = ((double)b2.getInt() / 2.147483647E9 + 1.0) / 2.0;
        b2.clear();
        return result;
    }
}

