/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.sampling;

import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

class ScoredTuple
implements Comparable<ScoredTuple> {
    Double score;
    private Tuple tuple;

    public ScoredTuple() {
    }

    public ScoredTuple(Double score, Tuple tuple) {
        this.score = score;
        this.setTuple(tuple);
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public void setTuple(Tuple tuple) {
        this.tuple = tuple;
    }

    public Tuple getIntermediateTuple(TupleFactory tupleFactory) {
        Tuple intermediateTuple = tupleFactory.newTuple(2);
        try {
            intermediateTuple.set(0, (Object)this.score);
            intermediateTuple.set(1, (Object)this.tuple);
        }
        catch (ExecException e) {
            throw new RuntimeException(e);
        }
        return intermediateTuple;
    }

    public static ScoredTuple fromIntermediateTuple(Tuple intermediateTuple) throws ExecException {
        try {
            Double score = (Double)intermediateTuple.get(0);
            Tuple originalTuple = (Tuple)intermediateTuple.get(1);
            return new ScoredTuple(score, originalTuple);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot deserialize intermediate tuple: " + intermediateTuple.toString(), e);
        }
    }

    @Override
    public int compareTo(ScoredTuple o) {
        if (this.score == null) {
            if (o == null) {
                return 0;
            }
            return -1;
        }
        return this.score.compareTo(o.score);
    }

    static class PureRandomScoreGenerator
    implements ScoreGenerator {
        @Override
        public double generateScore(Tuple sample) {
            return Math.random();
        }
    }

    static interface ScoreGenerator {
        public double generateScore(Tuple var1) throws ExecException;
    }
}

