/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.sampling;

import java.io.IOException;
import java.util.Comparator;
import org.apache.pig.AlgebraicEvalFunc;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class SimpleRandomSampleWithReplacementElect
extends AlgebraicEvalFunc<DataBag> {
    public static final String OUTPUT_BAG_NAME_PREFIX = "SRSWR_ELECT";
    public static final TupleFactory tupleFactory = TupleFactory.getInstance();
    public static final BagFactory bagFactory = BagFactory.getInstance();

    public SimpleRandomSampleWithReplacementElect() {
        super(new String[0]);
    }

    public String getInitial() {
        return Initial.class.getName();
    }

    public String getIntermed() {
        return Intermediate.class.getName();
    }

    public String getFinal() {
        return Final.class.getName();
    }

    public Schema outputSchema(Schema input) {
        try {
            Schema.FieldSchema inputFieldSchema = input.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            Schema outputSchema = new Schema(new Schema.FieldSchema(super.getSchemaName(OUTPUT_BAG_NAME_PREFIX, input), inputFieldSchema.schema.getField((int)0).schema.getField((int)2).schema, 120));
            return outputSchema;
        }
        catch (FrontendException e) {
            throw new RuntimeException("Error deriving output schema.", e);
        }
    }

    public static class Final
    extends EvalFunc<DataBag> {
        public DataBag exec(Tuple tuple) throws IOException {
            DataBag candidates = bagFactory.newSortedBag((Comparator)CandidateComparator.get());
            for (Tuple intermediateOutputTuple : (DataBag)tuple.get(0)) {
                candidates.addAll((DataBag)intermediateOutputTuple.get(0));
            }
            DataBag outputBag = bagFactory.newDefaultBag();
            int i = -1;
            for (Tuple candidate : candidates) {
                int pos = (Integer)candidate.get(0);
                if (pos <= i) continue;
                outputBag.add((Tuple)candidate.get(2));
                i = pos;
            }
            return outputBag;
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple tuple) throws IOException {
            DataBag candidates = bagFactory.newSortedBag((Comparator)CandidateComparator.get());
            for (Tuple intermediateOutputTuple : (DataBag)tuple.get(0)) {
                candidates.addAll((DataBag)intermediateOutputTuple.get(0));
            }
            DataBag outputBag = bagFactory.newDefaultBag();
            int i = -1;
            for (Tuple candidate : candidates) {
                int pos = (Integer)candidate.get(0);
                if (pos <= i) continue;
                outputBag.add(candidate);
                i = pos;
            }
            return tupleFactory.newTuple((Object)outputBag);
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            return input;
        }
    }

    static class CandidateComparator
    implements Comparator<Tuple> {
        private static CandidateComparator _instance = new CandidateComparator();

        public static CandidateComparator get() {
            return _instance;
        }

        private CandidateComparator() {
        }

        @Override
        public int compare(Tuple o1, Tuple o2) {
            try {
                int c1 = ((Integer)o1.get(0)).compareTo((Integer)o2.get(0));
                if (c1 != 0) {
                    return c1;
                }
                return ((Double)o1.get(1)).compareTo((Double)o2.get(1));
            }
            catch (ExecException e) {
                throw new RuntimeException("Error comparing tuples " + o1 + " and " + o2, e);
            }
        }
    }
}

