/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.sampling;

import datafu.pig.sampling.ReservoirSample;
import datafu.pig.sampling.ScoredTuple;
import java.util.Arrays;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.Nondeterministic;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

@Nondeterministic
public class WeightedReservoirSample
extends ReservoirSample {
    private Integer weightIdx;
    String param = null;

    public WeightedReservoirSample(String strNumSamples, String strWeightIdx) {
        super(strNumSamples);
        this.weightIdx = Integer.parseInt(strWeightIdx);
        if (this.weightIdx < 0) {
            throw new IllegalArgumentException("Invalid negative index of weight field argument for WeightedReserviorSample constructor: " + strWeightIdx);
        }
    }

    @Override
    protected ScoredTuple.ScoreGenerator getScoreGenerator() {
        if (this.scoreGen == null) {
            this.scoreGen = new InverseWeightScoreGenerator(this.weightIdx);
        }
        return this.scoreGen;
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            Schema.FieldSchema inputFieldSchema = input.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            Schema inputBagSchema = inputFieldSchema.schema;
            if (inputBagSchema.getField((int)0).type != 110) {
                throw new RuntimeException(String.format("Expected input bag to contain a TUPLE, but instead found %s", DataType.findTypeName((byte)inputBagSchema.getField((int)0).type)));
            }
            Schema tupleSchema = inputBagSchema.getField((int)0).schema;
            if (tupleSchema == null) {
                throw new RuntimeException("The tuple of input bag has no schema");
            }
            List fieldSchemaList = tupleSchema.getFields();
            if (fieldSchemaList == null || fieldSchemaList.size() <= Math.max(0, this.weightIdx)) {
                throw new RuntimeException("The field schema of the input tuple is null or the tuple size is no more than the weight field index: " + this.weightIdx);
            }
            if (((Schema.FieldSchema)fieldSchemaList.get((int)this.weightIdx.intValue())).type != 10 && ((Schema.FieldSchema)fieldSchemaList.get((int)this.weightIdx.intValue())).type != 15 && ((Schema.FieldSchema)fieldSchemaList.get((int)this.weightIdx.intValue())).type != 20 && ((Schema.FieldSchema)fieldSchemaList.get((int)this.weightIdx.intValue())).type != 25) {
                Object[] expectedTypes = new String[]{DataType.findTypeName((byte)10), DataType.findTypeName((byte)15), DataType.findTypeName((byte)20), DataType.findTypeName((byte)25)};
                throw new RuntimeException("Expect the type of the weight field of the input tuple to be of (" + Arrays.toString(expectedTypes) + "), but instead found (" + DataType.findTypeName((byte)((Schema.FieldSchema)fieldSchemaList.get((int)this.weightIdx.intValue())).type) + "), weight field: " + this.weightIdx);
            }
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), inputFieldSchema.schema, 120));
        }
        catch (FrontendException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String getParam() {
        if (this.param == null) {
            this.param = this.numSamples != null && this.weightIdx != null ? String.format("('%d','%d')", this.numSamples, this.weightIdx) : "";
        }
        return this.param;
    }

    @Override
    public String getInitial() {
        return Initial.class.getName() + this.getParam();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName() + this.getParam();
    }

    @Override
    public String getFinal() {
        return Final.class.getName() + this.getParam();
    }

    static class InverseWeightScoreGenerator
    implements ScoredTuple.ScoreGenerator {
        private int weightIdx;

        InverseWeightScoreGenerator(Integer weightIdx) {
            if (weightIdx == null || weightIdx < 0) {
                throw new IllegalArgumentException("Invalid null or negative weight index input: " + weightIdx);
            }
            this.weightIdx = weightIdx;
        }

        @Override
        public double generateScore(Tuple sample) throws ExecException {
            if (this.weightIdx >= sample.size()) {
                throw new ExecException(String.format("Weight index %d is outside tuple bounds", this.weightIdx));
            }
            if (sample.get(this.weightIdx) == null) {
                throw new ExecException(String.format("null value for weight at index %d", this.weightIdx));
            }
            double weight = ((Number)sample.get(this.weightIdx)).doubleValue();
            if (Double.compare(weight, 0.0) <= 0) {
                throw new ExecException(String.format("Invalid sample weight [%f]. It should be a positive real number", weight));
            }
            return Math.pow(Math.random(), 1.0 / weight);
        }
    }

    public static class Final
    extends ReservoirSample.Final {
        public Final() {
        }

        public Final(String strNumSamples, String strWeightIdx) {
            super(strNumSamples);
        }
    }

    public static class Intermediate
    extends ReservoirSample.Intermediate {
        public Intermediate() {
        }

        public Intermediate(String strNumSamples, String strWeightIdx) {
            super(strNumSamples);
        }
    }

    public static class Initial
    extends ReservoirSample.Initial {
        private Integer weightIdx;

        public Initial() {
            this.weightIdx = null;
        }

        public Initial(String strNumSamples, String strWeightIdx) {
            super(strNumSamples);
            this.weightIdx = Integer.parseInt(strWeightIdx);
            if (this.weightIdx < 0) {
                throw new IllegalArgumentException("Invalid negative index of weight field for WeightedReserviorSample.Initial constructor: " + strWeightIdx);
            }
        }

        @Override
        protected ScoredTuple.ScoreGenerator getScoreGenerator() {
            if (this.scoreGen == null) {
                this.scoreGen = new InverseWeightScoreGenerator(this.weightIdx);
            }
            return this.scoreGen;
        }
    }
}

