/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.sessions;

import java.io.IOException;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;

public class SessionCount
extends AccumulatorEvalFunc<Long> {
    private final long millis;
    private DateTime last_date;
    private long sum;

    public SessionCount(String timeSpec) {
        Period p = new Period((Object)("PT" + timeSpec.toUpperCase()));
        this.millis = p.toStandardDuration().getMillis();
        this.cleanup();
    }

    public void accumulate(Tuple input) throws IOException {
        for (Tuple t : (DataBag)input.get(0)) {
            DateTime date = new DateTime(t.get(0));
            if (this.last_date == null) {
                this.last_date = date;
                this.sum = 1L;
            } else if (date.isAfter((ReadableInstant)this.last_date.plus(this.millis))) {
                ++this.sum;
            } else if (date.isBefore((ReadableInstant)this.last_date)) {
                throw new IOException("input time series is not sorted");
            }
            this.last_date = date;
        }
    }

    public Long getValue() {
        return this.sum;
    }

    public void cleanup() {
        this.last_date = null;
        this.sum = 0L;
    }
}

