/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.sets;

import datafu.pig.sets.SetOperationsBase;
import java.io.IOException;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;

public class SetIntersect
extends SetOperationsBase {
    private static final BagFactory bagFactory = BagFactory.getInstance();

    private PriorityQueue<pair> load_bags(Tuple input) throws IOException {
        PriorityQueue<pair> pq = new PriorityQueue<pair>(input.size());
        for (int i = 0; i < input.size(); ++i) {
            Object o = input.get(i);
            if (!(o instanceof DataBag)) {
                throw new RuntimeException("parameters must be databags");
            }
            Iterator inputIterator = ((DataBag)o).iterator();
            if (!inputIterator.hasNext()) continue;
            pq.add(new pair(inputIterator));
        }
        return pq;
    }

    public boolean all_equal(PriorityQueue<pair> pq) {
        Tuple o = pq.peek().data;
        for (pair p : pq) {
            if (o.equals(p.data)) continue;
            return false;
        }
        return true;
    }

    public DataBag exec(Tuple input) throws IOException {
        DataBag outputBag = bagFactory.newDefaultBag();
        PriorityQueue<pair> pq = this.load_bags(input);
        if (pq.size() != input.size()) {
            return outputBag;
        }
        Tuple last_data = null;
        while (true) {
            if (pq.peek().data.compareTo(last_data) != 0 && this.all_equal(pq)) {
                last_data = pq.peek().data;
                outputBag.add(last_data);
            }
            pair p = pq.poll();
            if (!p.it.hasNext()) break;
            Tuple nextData = p.it.next();
            if (p.data.compareTo((Object)nextData) > 0) {
                throw new RuntimeException("Out of order!");
            }
            p.data = nextData;
            pq.offer(p);
        }
        return outputBag;
    }

    static class pair
    implements Comparable<pair> {
        final Iterator<Tuple> it;
        Tuple data;

        pair(Iterator<Tuple> it) {
            this.it = it;
            this.data = it.next();
        }

        @Override
        public int compareTo(pair o) {
            return this.data.compareTo((Object)o.data);
        }
    }
}

