/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats;

import com.clearspring.analytics.hash.MurmurHash;
import com.clearspring.analytics.stream.cardinality.CardinalityMergeException;
import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.AlgebraicEvalFunc;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class HyperLogLogPlusPlus
extends AlgebraicEvalFunc<Long> {
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private String p;
    private String param = null;

    public HyperLogLogPlusPlus() {
        this("20");
    }

    public HyperLogLogPlusPlus(String p) {
        super(new String[]{p});
        this.p = p;
        this.cleanup();
    }

    public Schema outputSchema(Schema input) {
        try {
            if (input.size() != 1) {
                throw new RuntimeException("Expected input to have only a single field");
            }
            Schema.FieldSchema inputFieldSchema = input.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            return new Schema(new Schema.FieldSchema(null, 15));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }

    private String getParam() {
        if (this.param == null) {
            this.param = this.p != null ? String.format("('%s')", this.p) : "";
        }
        return this.param;
    }

    public String getFinal() {
        return Final.class.getName() + this.getParam();
    }

    public String getInitial() {
        return Initial.class.getName() + this.getParam();
    }

    public String getIntermed() {
        return Intermediate.class.getName() + this.getParam();
    }

    protected static HyperLogLogPlus countDisctinct(Tuple input, int p) throws NumberFormatException, IOException {
        HyperLogLogPlus estimator = new HyperLogLogPlus(p);
        DataBag values = (DataBag)input.get(0);
        for (Tuple t : values) {
            Object data = t.get(0);
            if (data instanceof Long) {
                estimator.offerHashed(((Long)data).longValue());
                continue;
            }
            if (!(data instanceof DataByteArray)) continue;
            DataByteArray bytes = (DataByteArray)data;
            try {
                HyperLogLogPlus newEstimator = HyperLogLogPlus.Builder.build((byte[])bytes.get());
                estimator = (HyperLogLogPlus)estimator.merge(new ICardinality[]{newEstimator});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (CardinalityMergeException e) {
                throw new RuntimeException(e);
            }
        }
        return estimator;
    }

    public static class Final
    extends EvalFunc<Long> {
        private String p;

        public Final() {
            this("20");
        }

        public Final(String p) {
            this.p = p;
        }

        public Long exec(Tuple input) throws IOException {
            try {
                return HyperLogLogPlusPlus.countDisctinct(input, Integer.parseInt(this.p)).cardinality();
            }
            catch (Exception ee) {
                int errCode = 2106;
                String msg = "Error while computing count in " + ((Object)((Object)this)).getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, (Throwable)ee);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        private String p;

        public Intermediate() {
            this("20");
        }

        public Intermediate(String p) {
            this.p = p;
        }

        public Tuple exec(Tuple input) throws IOException {
            try {
                DataByteArray data = new DataByteArray(HyperLogLogPlusPlus.countDisctinct(input, Integer.parseInt(this.p)).getBytes());
                return mTupleFactory.newTuple((Object)data);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing count in " + ((Object)((Object)this)).getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        public Initial() {
        }

        public Initial(String p) {
        }

        public Tuple exec(Tuple input) throws IOException {
            DataBag bag = (DataBag)input.get(0);
            Iterator it = bag.iterator();
            Tuple t = null;
            if (it.hasNext()) {
                t = (Tuple)it.next();
            }
            return mTupleFactory.newTuple((Object)MurmurHash.hash64(t));
        }
    }
}

