/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats;

import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class IntVAR
extends EvalFunc<Double>
implements Algebraic,
Accumulator<Double> {
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private Long intermediateSumSquare = null;
    private Long intermediateSum = null;
    private Long intermediateCount = null;

    public Double exec(Tuple input) throws IOException {
        Long sum = IntVAR.sum(input);
        Long sumSquare = IntVAR.sumSquare(input);
        if (sum == null) {
            return null;
        }
        long count = IntVAR.count(input);
        Double var = null;
        if (count > 0L) {
            Double avg = new Double((double)sum.longValue() / (double)count);
            Double avgSquare = new Double((double)sumSquare.longValue() / (double)count);
            var = avgSquare - avg * avg;
        }
        return var;
    }

    public String getInitial() {
        return Initial.class.getName();
    }

    public String getIntermed() {
        return Intermediate.class.getName();
    }

    public String getFinal() {
        return Final.class.getName();
    }

    protected static Tuple combine(DataBag values) throws ExecException {
        long sum = 0L;
        long sumSquare = 0L;
        long totalCount = 0L;
        Tuple output = mTupleFactory.newTuple(3);
        boolean sawNonNull = false;
        for (Tuple t : values) {
            Long i = (Long)t.get(0);
            Long iSquare = (Long)t.get(1);
            Long count = (Long)t.get(2);
            if (i == null) {
                i = 0L;
                iSquare = 0L;
            } else {
                sawNonNull = true;
            }
            sum += i.longValue();
            sumSquare += iSquare.longValue();
            totalCount += count.longValue();
        }
        if (sawNonNull) {
            output.set(0, (Object)new Long(sum));
            output.set(1, (Object)new Long(sumSquare));
        } else {
            output.set(0, null);
            output.set(1, null);
        }
        output.set(2, (Object)totalCount);
        return output;
    }

    protected static long count(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        long cnt = 0L;
        for (Tuple t : values) {
            if (t == null || t.size() <= 0 || t.get(0) == null) continue;
            ++cnt;
        }
        return cnt;
    }

    protected static Long sum(Tuple input) throws ExecException, IOException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        long sum = 0L;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Integer i = (Integer)t.get(0);
                if (i == null) continue;
                sawNonNull = true;
                sum += (long)i.intValue();
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing sum of values.";
                throw new ExecException(msg, errCode, 4, (Throwable)exp);
            }
        }
        if (sawNonNull) {
            return new Long(sum);
        }
        return null;
    }

    protected static Long sumSquare(Tuple input) throws ExecException, IOException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        long sumSquare = 0L;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Integer i = (Integer)t.get(0);
                if (i == null) continue;
                sawNonNull = true;
                sumSquare += (long)(i * i);
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing sum of squared values.";
                throw new ExecException(msg, errCode, 4, (Throwable)exp);
            }
        }
        if (sawNonNull) {
            return new Long(sumSquare);
        }
        return null;
    }

    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 25));
    }

    public void accumulate(Tuple b) throws IOException {
        try {
            long count;
            Long sum = IntVAR.sum(b);
            if (sum == null) {
                return;
            }
            Long sumSquare = IntVAR.sumSquare(b);
            if (sumSquare == null) {
                return;
            }
            if (this.intermediateSum == null || this.intermediateCount == null) {
                this.intermediateSumSquare = 0L;
                this.intermediateSum = 0L;
                this.intermediateCount = 0L;
            }
            if ((count = Long.valueOf(IntVAR.count(b)).longValue()) > 0L) {
                this.intermediateCount = this.intermediateCount + count;
                this.intermediateSum = this.intermediateSum + sum;
                this.intermediateSumSquare = this.intermediateSumSquare + sumSquare;
            }
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing variance in " + ((Object)((Object)this)).getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, (Throwable)e);
        }
    }

    public void cleanup() {
        this.intermediateSumSquare = null;
        this.intermediateSum = null;
        this.intermediateCount = null;
    }

    public Double getValue() {
        Double var = null;
        if (this.intermediateCount != null && this.intermediateCount > 0L) {
            Double avg = new Double((double)this.intermediateSum.longValue() / (double)this.intermediateCount.longValue());
            Double avgSquare = new Double((double)this.intermediateSumSquare.longValue() / (double)this.intermediateCount.longValue());
            var = avgSquare - avg * avg;
        }
        return var;
    }

    public static class Final
    extends EvalFunc<Double> {
        public Double exec(Tuple input) throws IOException {
            try {
                DataBag b = (DataBag)input.get(0);
                Tuple combined = IntVAR.combine(b);
                Long sum = (Long)combined.get(0);
                Long sumSquare = (Long)combined.get(1);
                if (sum == null) {
                    return null;
                }
                Long count = (Long)combined.get(2);
                Double var = null;
                if (count > 0L) {
                    Double avg = new Double((double)sum.longValue() / (double)count.longValue());
                    Double avgSquare = new Double((double)sumSquare.longValue() / (double)count.longValue());
                    var = avgSquare - avg * avg;
                }
                return var;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing variance in " + ((Object)((Object)this)).getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag b = (DataBag)input.get(0);
                return IntVAR.combine(b);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing variacne in " + ((Object)((Object)this)).getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            Tuple t = mTupleFactory.newTuple(3);
            try {
                DataBag bg = (DataBag)input.get(0);
                Integer i = null;
                Iterator iter = bg.iterator();
                if (iter.hasNext()) {
                    Tuple tp = (Tuple)iter.next();
                    i = (Integer)tp.get(0);
                }
                if (iter.hasNext()) {
                    throw new RuntimeException("Expected only one tuple in bag");
                }
                if (i == null) {
                    t.set(2, (Object)0L);
                    t.set(0, null);
                    t.set(1, null);
                } else {
                    t.set(2, (Object)1L);
                    t.set(0, (Object)i);
                    t.set(1, (Object)((long)i.intValue() * (long)i.intValue()));
                }
                return t;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                t.set(0, null);
                t.set(1, null);
                t.set(2, (Object)0L);
                return t;
            }
            catch (ExecException ee) {
                ee.printStackTrace();
                throw ee;
            }
            catch (Exception e) {
                e.printStackTrace();
                int errCode = 2106;
                String msg = "Error while computing variance in " + ((Object)((Object)this)).getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, (Throwable)e);
            }
        }
    }
}

