/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class MarkovPairs
extends EvalFunc<DataBag> {
    private static final BagFactory bagFactory = BagFactory.getInstance();
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    private static long lookahead_steps;
    private final int SPILL_THRESHOLD = 1000000;

    public MarkovPairs() {
        lookahead_steps = 1L;
    }

    public MarkovPairs(String lookahead_steps) {
        MarkovPairs.lookahead_steps = Integer.valueOf(lookahead_steps).intValue();
    }

    private void generatePairs(ArrayList<Tuple> input, int start, int end, DataBag outputBag) throws ExecException {
        int count = 0;
        int i = start;
        while (i + 1 <= end) {
            Tuple elem1 = input.get(i);
            for (int j = i + 1; (long)j <= (long)i + lookahead_steps && j <= end; ++j) {
                Tuple elem2 = input.get(j);
                if (count >= 1000000) {
                    outputBag.spill();
                    count = 0;
                }
                outputBag.add(tupleFactory.newTuple(Arrays.asList(elem1, elem2)));
                ++count;
            }
            ++i;
        }
    }

    public DataBag exec(Tuple input) throws IOException {
        DataBag inputBag = (DataBag)input.get(0);
        ArrayList<Tuple> inputData = new ArrayList<Tuple>();
        for (Tuple tuple : inputBag) {
            inputData.add(tuple);
        }
        int inputSize = inputData.size();
        try {
            DataBag outputBag = bagFactory.newDefaultBag();
            int startPos = 0;
            int stopPos = inputSize - 1;
            this.generatePairs(inputData, startPos, stopPos, outputBag);
            startPos = stopPos + 1;
            return outputBag;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Schema outputSchema(Schema input) {
        try {
            Schema tupleSchema = new Schema();
            Schema.FieldSchema fieldSchema = input.getField(0);
            if (fieldSchema.type != 120) {
                throw new RuntimeException(String.format("Expected input schema to be BAG, but instead found %s", DataType.findTypeName((byte)fieldSchema.type)));
            }
            Schema.FieldSchema fieldSchema2 = fieldSchema.schema.getField(0);
            tupleSchema.add(new Schema.FieldSchema("elem1", fieldSchema2.schema));
            tupleSchema.add(new Schema.FieldSchema("elem2", fieldSchema2.schema));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 120));
        }
        catch (Exception e) {
            return null;
        }
    }
}

