/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats;

import datafu.pig.stats.QuantileUtil;
import datafu.pig.util.SimpleEvalFunc;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class Quantile
extends SimpleEvalFunc<Tuple> {
    List<Double> quantiles;
    private boolean ordinalOutputSchema;

    public Quantile(String ... k) {
        this.quantiles = QuantileUtil.getQuantilesFromParams(k);
        if (k.length == 1 && Double.parseDouble(k[0]) > 1.0) {
            this.ordinalOutputSchema = true;
            this.quantiles = QuantileUtil.getQuantilesFromParams(k);
        } else {
            this.quantiles = QuantileUtil.getQuantilesFromParams(k);
        }
    }

    private static Pair<Long, Long> getIndexes(double k, long N) {
        double h = (double)N * k + 0.5;
        long i1 = Math.min(Math.max(1L, (long)Math.ceil(h - 0.5)), N);
        long i2 = Math.min(Math.max(1L, (long)Math.floor(h + 0.5)), N);
        return new Pair<Long, Long>(i1, i2);
    }

    public Tuple call(DataBag bag) throws IOException {
        if (bag == null || bag.size() == 0L) {
            return null;
        }
        HashMap<Object, Double> d = new HashMap<Object, Double>();
        long N = bag.size();
        long max_id = 1L;
        for (double k : this.quantiles) {
            Pair<Long, Long> idx = Quantile.getIndexes(k, N);
            d.put(idx.first, null);
            d.put(idx.second, null);
            max_id = Math.max(max_id, (Long)idx.second);
        }
        long i = 1L;
        for (Tuple t : bag) {
            if (i > max_id) break;
            if (d.containsKey(i)) {
                Object o = t.get(0);
                if (!(o instanceof Number)) {
                    throw new IllegalStateException("bag must have numerical values (and be non-null)");
                }
                d.put(i, ((Number)o).doubleValue());
            }
            ++i;
        }
        Tuple t = TupleFactory.getInstance().newTuple(this.quantiles.size());
        int j = 0;
        for (double k : this.quantiles) {
            Pair<Long, Long> p = Quantile.getIndexes(k, N);
            double quantile = ((Double)d.get(p.first) + (Double)d.get(p.second)) / 2.0;
            t.set(j, (Object)quantile);
            ++j;
        }
        return t;
    }

    @Override
    public Schema outputSchema(Schema input) {
        Schema tupleSchema = new Schema();
        if (this.ordinalOutputSchema) {
            for (int i = 0; i < this.quantiles.size(); ++i) {
                tupleSchema.add(new Schema.FieldSchema("quantile_" + i, 25));
            }
        } else {
            for (Double x : this.quantiles) {
                tupleSchema.add(new Schema.FieldSchema("quantile_" + x.toString().replace(".", "_"), 25));
            }
        }
        try {
            return new Schema(new Schema.FieldSchema(null, tupleSchema, 110));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Pair<T1, T2> {
        public T1 first;
        public T2 second;

        public Pair(T1 first, T2 second) {
            this.first = first;
            this.second = second;
        }
    }
}

