/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats;

import java.util.ArrayList;

public class QuantileUtil {
    public static ArrayList<Double> getNQuantiles(int numQuantiles) {
        ArrayList<Double> quantiles = new ArrayList<Double>(numQuantiles);
        quantiles = new ArrayList(numQuantiles);
        int divisor = numQuantiles - 1;
        for (int q = 0; q <= divisor; ++q) {
            double quantile = (double)q / (double)divisor;
            quantiles.add(quantile);
        }
        return quantiles;
    }

    public static ArrayList<Double> getQuantilesFromParams(String ... k) {
        ArrayList<Double> quantiles = new ArrayList<Double>(k.length);
        for (String s : k) {
            quantiles.add(Double.parseDouble(s));
        }
        if (quantiles.size() == 1 && (Double)quantiles.get(0) > 1.0) {
            int numQuantiles = Integer.parseInt(k[0]);
            if (numQuantiles < 1) {
                throw new IllegalArgumentException("Number of quantiles must be greater than 1");
            }
            quantiles = QuantileUtil.getNQuantiles(numQuantiles);
        } else {
            for (Double d : quantiles) {
                if (!(d < 0.0) && !(d > 1.0)) continue;
                throw new IllegalArgumentException("Quantile must be between 0.0 and 1.0");
            }
        }
        return quantiles;
    }
}

