/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats;

import datafu.pig.stats.DoubleVAR;
import datafu.pig.stats.FloatVAR;
import datafu.pig.stats.IntVAR;
import datafu.pig.stats.LongVAR;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class VAR
extends EvalFunc<Double>
implements Algebraic,
Accumulator<Double> {
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    private Double intermediateSumSquare = null;
    private Double intermediateSum = null;
    private Long intermediateCount = null;

    public Double exec(Tuple input) throws IOException {
        Double sum = VAR.sum(input);
        Double sumSquare = VAR.sumSquare(input);
        if (sum == null) {
            return null;
        }
        long count = VAR.count(input);
        Double var = null;
        if (count > 0L) {
            Double avg = new Double(sum / (double)count);
            Double avgSquare = new Double(sumSquare / (double)count);
            var = avgSquare - avg * avg;
        }
        return var;
    }

    public String getInitial() {
        return Initial.class.getName();
    }

    public String getIntermed() {
        return Intermediate.class.getName();
    }

    public String getFinal() {
        return Final.class.getName();
    }

    protected static Tuple combine(DataBag values) throws ExecException {
        double sum = 0.0;
        double sumSquare = 0.0;
        long totalCount = 0L;
        Tuple output = mTupleFactory.newTuple(3);
        boolean sawNonNull = false;
        for (Tuple t : values) {
            Double d = (Double)t.get(0);
            Double dSquare = (Double)t.get(1);
            Long count = (Long)t.get(2);
            if (d == null) {
                d = 0.0;
            } else {
                sawNonNull = true;
            }
            sum += d.doubleValue();
            sumSquare += dSquare.doubleValue();
            totalCount += count.longValue();
        }
        if (sawNonNull) {
            output.set(0, (Object)new Double(sum));
            output.set(1, (Object)new Double(sumSquare));
        } else {
            output.set(0, null);
            output.set(1, null);
        }
        output.set(2, (Object)totalCount);
        return output;
    }

    protected static long count(Tuple input) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        long cnt = 0L;
        for (Tuple t : values) {
            if (t == null || t.size() <= 0 || t.get(0) == null) continue;
            ++cnt;
        }
        return cnt;
    }

    protected static Double sum(Tuple input) throws ExecException, IOException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        double sum = 0.0;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Double d;
                DataByteArray dba = (DataByteArray)t.get(0);
                Double d2 = d = dba != null ? Double.valueOf(dba.toString()) : null;
                if (d == null) continue;
                sawNonNull = true;
                sum += d.doubleValue();
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing sum of values.";
                throw new ExecException(msg, errCode, 4, (Throwable)exp);
            }
        }
        if (sawNonNull) {
            return new Double(sum);
        }
        return null;
    }

    protected static Double sumSquare(Tuple input) throws ExecException, IOException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        double sumSquare = 0.0;
        boolean sawNonNull = false;
        for (Tuple t : values) {
            try {
                Double d;
                DataByteArray dba = (DataByteArray)t.get(0);
                Double d2 = d = dba != null ? Double.valueOf(dba.toString()) : null;
                if (d == null) continue;
                sawNonNull = true;
                sumSquare += d * d;
            }
            catch (RuntimeException exp) {
                int errCode = 2103;
                String msg = "Problem while computing sum of squared values.";
                throw new ExecException(msg, errCode, 4, (Throwable)exp);
            }
        }
        if (sawNonNull) {
            return new Double(sumSquare);
        }
        return null;
    }

    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 25));
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), Schema.generateNestedSchema((byte)120, (byte[])new byte[]{50})));
        funcList.add(new FuncSpec(DoubleVAR.class.getName(), Schema.generateNestedSchema((byte)120, (byte[])new byte[]{25})));
        funcList.add(new FuncSpec(FloatVAR.class.getName(), Schema.generateNestedSchema((byte)120, (byte[])new byte[]{20})));
        funcList.add(new FuncSpec(IntVAR.class.getName(), Schema.generateNestedSchema((byte)120, (byte[])new byte[]{10})));
        funcList.add(new FuncSpec(LongVAR.class.getName(), Schema.generateNestedSchema((byte)120, (byte[])new byte[]{15})));
        return funcList;
    }

    public void accumulate(Tuple b) throws IOException {
        try {
            long count;
            Double sum = VAR.sum(b);
            if (sum == null) {
                return;
            }
            Double sumSquare = VAR.sumSquare(b);
            if (sumSquare == null) {
                return;
            }
            if (this.intermediateSum == null || this.intermediateCount == null) {
                this.intermediateSumSquare = 0.0;
                this.intermediateSum = 0.0;
                this.intermediateCount = 0L;
            }
            if ((count = Long.valueOf(VAR.count(b)).longValue()) > 0L) {
                this.intermediateCount = this.intermediateCount + count;
                this.intermediateSum = this.intermediateSum + sum;
                this.intermediateSumSquare = this.intermediateSumSquare + sumSquare;
            }
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2106;
            String msg = "Error while computing variance in " + ((Object)((Object)this)).getClass().getSimpleName();
            throw new ExecException(msg, errCode, 4, (Throwable)e);
        }
    }

    public void cleanup() {
        this.intermediateSumSquare = null;
        this.intermediateSum = null;
        this.intermediateCount = null;
    }

    public Double getValue() {
        Double var = null;
        if (this.intermediateCount != null && this.intermediateCount > 0L) {
            Double avg = new Double(this.intermediateSum / (double)this.intermediateCount.longValue());
            Double avgSquare = new Double(this.intermediateSumSquare / (double)this.intermediateCount.longValue());
            var = avgSquare - avg * avg;
        }
        return var;
    }

    public static class Final
    extends EvalFunc<Double> {
        public Double exec(Tuple input) throws IOException {
            try {
                DataBag b = (DataBag)input.get(0);
                Tuple combined = VAR.combine(b);
                Double sum = (Double)combined.get(0);
                Double sumSquare = (Double)combined.get(1);
                if (sum == null) {
                    return null;
                }
                Long count = (Long)combined.get(2);
                Double var = null;
                if (count > 0L) {
                    Double avg = new Double(sum / (double)count.longValue());
                    Double avgSquare = new Double(sumSquare / (double)count.longValue());
                    var = avgSquare - avg * avg;
                }
                return var;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing variance in " + ((Object)((Object)this)).getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag b = (DataBag)input.get(0);
                return VAR.combine(b);
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2106;
                String msg = "Error while computing variacne in " + ((Object)((Object)this)).getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            Tuple t = mTupleFactory.newTuple(3);
            try {
                Double d;
                DataBag bg = (DataBag)input.get(0);
                DataByteArray dba = null;
                Iterator iter = bg.iterator();
                if (iter.hasNext()) {
                    Tuple tp = (Tuple)iter.next();
                    dba = (DataByteArray)tp.get(0);
                }
                if (iter.hasNext()) {
                    throw new RuntimeException("Expected only one tuple in bag");
                }
                Double d2 = d = dba != null ? Double.valueOf(dba.toString()) : null;
                if (dba == null) {
                    t.set(0, null);
                    t.set(1, null);
                    t.set(2, (Object)0L);
                } else {
                    t.set(0, (Object)d);
                    t.set(1, (Object)(d * d));
                    t.set(2, (Object)1L);
                }
                return t;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                t.set(0, null);
                t.set(1, null);
                t.set(2, (Object)0L);
                return t;
            }
            catch (ExecException ee) {
                ee.printStackTrace();
                throw ee;
            }
            catch (Exception e) {
                e.printStackTrace();
                int errCode = 2106;
                String msg = "Error while computing variance in " + ((Object)((Object)this)).getClass().getSimpleName();
                throw new ExecException(msg, errCode, 4, (Throwable)e);
            }
        }
    }
}

