/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats;

import datafu.pig.util.SimpleEvalFunc;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class WilsonBinConf
extends SimpleEvalFunc<Tuple> {
    private static TupleFactory tupleFactory = TupleFactory.getInstance();
    private final double alpha;

    public WilsonBinConf(double alpha) {
        this.alpha = alpha;
    }

    public WilsonBinConf(String alpha) {
        this(Double.parseDouble(alpha));
    }

    public Tuple call(Number x, Number n) throws IOException {
        if (x == null || n == null) {
            return null;
        }
        return this.binconf(x.longValue(), n.longValue());
    }

    public Tuple binconf(Long x, Long n) throws IOException {
        NormalDistributionImpl normalDist = new NormalDistributionImpl();
        if (x == null || n == null) {
            return null;
        }
        if (x < 0L || n < 0L) {
            throw new IllegalArgumentException("non-negative values expected");
        }
        if (x > n) {
            throw new IllegalArgumentException("invariant violation: number of successes > number of obs");
        }
        if (n == 0L) {
            return tupleFactory.newTuple(Arrays.asList(0.0, 0.0));
        }
        try {
            double zcrit = -1.0 * normalDist.inverseCumulativeProbability(this.alpha / 2.0);
            double z2 = zcrit * zcrit;
            double p = (double)x.longValue() / (double)n.longValue();
            double a = p + z2 / 2.0 / (double)n.longValue();
            double b = zcrit * Math.sqrt((p * (1.0 - p) + z2 / 4.0 / (double)n.longValue()) / (double)n.longValue());
            double c = 1.0 + z2 / (double)n.longValue();
            double lower = (a - b) / c;
            double upper = (a + b) / c;
            if (x == 1L) {
                lower = -Math.log(1.0 - this.alpha) / (double)n.longValue();
            }
            if (x == n - 1L) {
                upper = 1.0 + Math.log(1.0 - this.alpha) / (double)n.longValue();
            }
            return tupleFactory.newTuple(Arrays.asList(lower, upper));
        }
        catch (MathException e) {
            throw new IOException("math error", e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            Schema innerSchema = new Schema(Arrays.asList(new Schema.FieldSchema("lower", 25), new Schema.FieldSchema("upper", 25)));
            return new Schema(new Schema.FieldSchema(null, innerSchema, 110));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

