/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats.entropy;

import datafu.pig.stats.entropy.EntropyEstimator;
import datafu.pig.stats.entropy.EntropyUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

class ChaoShenEntropyEstimator
extends EntropyEstimator {
    private AccumulativeSampleFrequencyMap freqBaggedMap;
    private long N;
    private long N1;

    ChaoShenEntropyEstimator(String base) {
        super(base);
        this.reset();
    }

    @Override
    public void accumulate(long cx) throws ExecException {
        if (cx > 0L) {
            this.freqBaggedMap.accumulate(cx);
            this.N += cx;
            if (cx == 1L) {
                ++this.N1;
            }
        }
    }

    @Override
    public double getEntropy() {
        double h = 0.0;
        if (this.N > 0L) {
            if (this.N1 == this.N) {
                this.N1 = this.N - 1L;
            }
            double c = 1.0 - (double)this.N1 / (double)this.N;
            try {
                long cnt;
                long cx;
                for (Map.Entry<Long, MutableLong> entry : this.freqBaggedMap.getInternalMap().entrySet()) {
                    cx = entry.getKey();
                    cnt = entry.getValue().longValue();
                    h += this.accumlateEntropy(cx, this.N, c, cnt);
                }
                for (Tuple t : this.freqBaggedMap.getInternalBag()) {
                    cx = (Long)t.get(0);
                    cnt = (Long)t.get(1);
                    h += this.accumlateEntropy(cx, this.N, c, cnt);
                }
            }
            catch (ExecException ex) {
                throw new RuntimeException("Error while computing chao-shen entropy, exception: " + (Object)((Object)ex));
            }
        }
        return EntropyUtil.logTransform(h, this.base);
    }

    private double accumlateEntropy(long cx, long N, double c, long cnt) {
        double p = (double)cx / (double)N;
        double pa = c * p;
        double la = 1.0 - Math.pow(1.0 - pa, N);
        return -((double)cnt * pa * Math.log(pa) / la);
    }

    @Override
    public void reset() {
        this.N = 0L;
        this.N1 = 0L;
        if (this.freqBaggedMap != null) {
            this.freqBaggedMap.clear();
        }
        this.freqBaggedMap = new AccumulativeSampleFrequencyMap();
    }

    private class MutableLong {
        private long val;

        MutableLong() {
            this(0L);
        }

        MutableLong(long val) {
            this.val = val;
        }

        long longValue() {
            return this.val;
        }

        void add(long additive) {
            this.val += additive;
        }
    }

    private class AccumulativeSampleFrequencyMap {
        private long spillBytesThreshold;
        private Map<Long, MutableLong> countMap;
        private DataBag countBag;

        AccumulativeSampleFrequencyMap() {
            this(0x5000000L);
        }

        AccumulativeSampleFrequencyMap(long spillBytesThreshold) {
            this.spillBytesThreshold = spillBytesThreshold;
            this.clear();
        }

        void accumulate(long key) throws ExecException {
            MutableLong val = this.countMap.get(key);
            if (val == null) {
                this.countMap.put(key, new MutableLong(1L));
            } else {
                val.add(1L);
            }
            if ((long)(this.countMap.size() * 128 / 8) > this.spillBytesThreshold) {
                this.spillFromMap2Bag();
            }
        }

        private void spillFromMap2Bag() throws ExecException {
            for (Map.Entry<Long, MutableLong> entry : this.countMap.entrySet()) {
                Tuple t = TupleFactory.getInstance().newTuple(2);
                t.set(0, (Object)entry.getKey());
                t.set(1, (Object)entry.getValue().longValue());
                this.countBag.add(t);
            }
            this.countMap.clear();
        }

        Map<Long, MutableLong> getInternalMap() {
            return Collections.unmodifiableMap(this.countMap);
        }

        DataBag getInternalBag() {
            return this.countBag;
        }

        void clear() {
            this.countMap = new HashMap<Long, MutableLong>();
            this.countBag = BagFactory.getInstance().newDefaultBag();
        }
    }
}

