/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats.entropy;

import datafu.pig.stats.entropy.EntropyEstimator;
import java.io.IOException;
import java.util.List;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class CondEntropy
extends AccumulatorEvalFunc<Double> {
    private Tuple xy;
    private long cxy;
    private long cx;
    private int lastCmp;
    private EntropyEstimator combEstimator;
    private EntropyEstimator condXEstimator;

    public CondEntropy() throws ExecException {
        this("empirical");
    }

    public CondEntropy(String type) throws ExecException {
        this(type, "log");
    }

    public CondEntropy(String type, String base) throws ExecException {
        try {
            this.combEstimator = EntropyEstimator.createEstimator(type, base);
            this.condXEstimator = EntropyEstimator.createEstimator(type, base);
        }
        catch (IllegalArgumentException ex) {
            throw new ExecException(String.format("Fail to initialize StreamingCondEntropy with entropy estimator of type (%s), base: (%s). Exception: (%s)", type, base, ex));
        }
        this.cleanup();
    }

    public void accumulate(Tuple input) throws IOException {
        for (Tuple t : (DataBag)input.get(0)) {
            if (this.xy != null) {
                int cmp = t.compareTo((Object)this.xy);
                if (cmp < 0 && this.lastCmp > 0 || cmp > 0 && this.lastCmp < 0) {
                    throw new ExecException("Out of order! previous tuple: " + this.xy + ", present tuple: " + t + ", comparsion: " + cmp + ", previous comparsion: " + this.lastCmp);
                }
                if (cmp != 0) {
                    this.combEstimator.accumulate(this.cxy);
                    this.cxy = 0L;
                    this.lastCmp = cmp;
                    if (DataType.compare((Object)this.xy.get(0), (Object)t.get(0)) != 0) {
                        this.condXEstimator.accumulate(this.cx);
                        this.cx = 0L;
                    }
                }
            }
            this.xy = t;
            ++this.cx;
            ++this.cxy;
        }
    }

    public Double getValue() {
        try {
            this.combEstimator.accumulate(this.cxy);
            this.condXEstimator.accumulate(this.cx);
        }
        catch (ExecException ex) {
            throw new RuntimeException("Error while accumulating sample frequency: " + (Object)((Object)ex));
        }
        return this.combEstimator.getEntropy() - this.condXEstimator.getEntropy();
    }

    public void cleanup() {
        this.xy = null;
        this.cxy = 0L;
        this.cx = 0L;
        this.lastCmp = 0;
        this.combEstimator.reset();
        this.condXEstimator.reset();
    }

    public Schema outputSchema(Schema input) {
        try {
            Schema.FieldSchema inputFieldSchema = input.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expected a BAG as input");
            }
            Schema inputBagSchema = inputFieldSchema.schema;
            if (inputBagSchema.getField((int)0).type != 110) {
                throw new RuntimeException(String.format("Expected input bag to contain a TUPLE, but instead found %s", DataType.findTypeName((byte)inputBagSchema.getField((int)0).type)));
            }
            Schema tupleSchema = inputBagSchema.getField((int)0).schema;
            if (tupleSchema == null) {
                throw new RuntimeException("The tuple of the input bag has no schema");
            }
            List fieldSchemaList = tupleSchema.getFields();
            if (fieldSchemaList == null || fieldSchemaList.size() != 2) {
                throw new RuntimeException("The field schema of the input tuple is null or its size is not 2");
            }
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 25));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

