/*
 * Decompiled with CFR 0.152.
 */
package datafu.pig.stats.entropy;

import datafu.pig.stats.entropy.EntropyEstimator;
import datafu.pig.stats.entropy.EntropyUtil;

class EmpiricalEntropyEstimator
extends EntropyEstimator {
    private long N;
    private double M;

    EmpiricalEntropyEstimator(String base) throws IllegalArgumentException {
        super(base);
        this.reset();
    }

    @Override
    public void accumulate(long cx) {
        if (cx > 0L) {
            this.N += cx;
            this.M += (double)cx * Math.log(cx);
        }
    }

    @Override
    public double getEntropy() {
        return this.N > 0L ? EntropyUtil.logTransform(Math.log(this.N) - this.M / (double)this.N, this.base) : 0.0;
    }

    @Override
    public void reset() {
        this.N = 0L;
        this.M = 0.0;
    }
}

